/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.NotebookResource;
import com.azure.analytics.synapse.artifacts.models.RunNotebookParameter;
import com.azure.analytics.synapse.artifacts.models.RunNotebookSparkSessionOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class RunNotebookSnapshot
implements JsonSerializable<RunNotebookSnapshot> {
    private String exitValue;
    private String id;
    private String notebook;
    private RunNotebookSparkSessionOptions sessionOptions;
    private Boolean honorSessionTimeToLive;
    private String sessionId;
    private String sparkPool;
    private Map<String, RunNotebookParameter> parameters;
    private NotebookResource notebookContent;

    public String getExitValue() {
        return this.exitValue;
    }

    public RunNotebookSnapshot setExitValue(String exitValue) {
        this.exitValue = exitValue;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public RunNotebookSnapshot setId(String id) {
        this.id = id;
        return this;
    }

    public String getNotebook() {
        return this.notebook;
    }

    public RunNotebookSnapshot setNotebook(String notebook) {
        this.notebook = notebook;
        return this;
    }

    public RunNotebookSparkSessionOptions getSessionOptions() {
        return this.sessionOptions;
    }

    public RunNotebookSnapshot setSessionOptions(RunNotebookSparkSessionOptions sessionOptions) {
        this.sessionOptions = sessionOptions;
        return this;
    }

    public Boolean isHonorSessionTimeToLive() {
        return this.honorSessionTimeToLive;
    }

    public RunNotebookSnapshot setHonorSessionTimeToLive(Boolean honorSessionTimeToLive) {
        this.honorSessionTimeToLive = honorSessionTimeToLive;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public RunNotebookSnapshot setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getSparkPool() {
        return this.sparkPool;
    }

    public RunNotebookSnapshot setSparkPool(String sparkPool) {
        this.sparkPool = sparkPool;
        return this;
    }

    public Map<String, RunNotebookParameter> getParameters() {
        return this.parameters;
    }

    public RunNotebookSnapshot setParameters(Map<String, RunNotebookParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public NotebookResource getNotebookContent() {
        return this.notebookContent;
    }

    public RunNotebookSnapshot setNotebookContent(NotebookResource notebookContent) {
        this.notebookContent = notebookContent;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("notebook", this.notebook);
        jsonWriter.writeStringField("exitValue", this.exitValue);
        jsonWriter.writeJsonField("sessionOptions", (JsonSerializable)this.sessionOptions);
        jsonWriter.writeBooleanField("honorSessionTimeToLive", this.honorSessionTimeToLive);
        jsonWriter.writeStringField("sessionId", this.sessionId);
        jsonWriter.writeStringField("sparkPool", this.sparkPool);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("notebookContent", (JsonSerializable)this.notebookContent);
        return jsonWriter.writeEndObject();
    }

    public static RunNotebookSnapshot fromJson(JsonReader jsonReader) throws IOException {
        return (RunNotebookSnapshot)jsonReader.readObject(reader -> {
            RunNotebookSnapshot deserializedRunNotebookSnapshot = new RunNotebookSnapshot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.id = reader.getString();
                    continue;
                }
                if ("notebook".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.notebook = reader.getString();
                    continue;
                }
                if ("exitValue".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.exitValue = reader.getString();
                    continue;
                }
                if ("sessionOptions".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.sessionOptions = RunNotebookSparkSessionOptions.fromJson(reader);
                    continue;
                }
                if ("honorSessionTimeToLive".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.honorSessionTimeToLive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sessionId".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.sessionId = reader.getString();
                    continue;
                }
                if ("sparkPool".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.sparkPool = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedRunNotebookSnapshot.parameters = parameters = reader.readMap(reader1 -> RunNotebookParameter.fromJson(reader1));
                    continue;
                }
                if ("notebookContent".equals(fieldName)) {
                    deserializedRunNotebookSnapshot.notebookContent = NotebookResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunNotebookSnapshot;
        });
    }
}

