/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.RunNotebookParameter;
import com.azure.analytics.synapse.artifacts.models.RunNotebookSparkSessionOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class RunNotebookRequest
implements JsonSerializable<RunNotebookRequest> {
    private String notebook;
    private String sparkPool;
    private RunNotebookSparkSessionOptions sessionOptions;
    private Boolean honorSessionTimeToLive;
    private Map<String, RunNotebookParameter> parameters;

    public String getNotebook() {
        return this.notebook;
    }

    public RunNotebookRequest setNotebook(String notebook) {
        this.notebook = notebook;
        return this;
    }

    public String getSparkPool() {
        return this.sparkPool;
    }

    public RunNotebookRequest setSparkPool(String sparkPool) {
        this.sparkPool = sparkPool;
        return this;
    }

    public RunNotebookSparkSessionOptions getSessionOptions() {
        return this.sessionOptions;
    }

    public RunNotebookRequest setSessionOptions(RunNotebookSparkSessionOptions sessionOptions) {
        this.sessionOptions = sessionOptions;
        return this;
    }

    public Boolean isHonorSessionTimeToLive() {
        return this.honorSessionTimeToLive;
    }

    public RunNotebookRequest setHonorSessionTimeToLive(Boolean honorSessionTimeToLive) {
        this.honorSessionTimeToLive = honorSessionTimeToLive;
        return this;
    }

    public Map<String, RunNotebookParameter> getParameters() {
        return this.parameters;
    }

    public RunNotebookRequest setParameters(Map<String, RunNotebookParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notebook", this.notebook);
        jsonWriter.writeStringField("sparkPool", this.sparkPool);
        jsonWriter.writeJsonField("sessionOptions", (JsonSerializable)this.sessionOptions);
        jsonWriter.writeBooleanField("honorSessionTimeToLive", this.honorSessionTimeToLive);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RunNotebookRequest fromJson(JsonReader jsonReader) throws IOException {
        return (RunNotebookRequest)jsonReader.readObject(reader -> {
            RunNotebookRequest deserializedRunNotebookRequest = new RunNotebookRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("notebook".equals(fieldName)) {
                    deserializedRunNotebookRequest.notebook = reader.getString();
                    continue;
                }
                if ("sparkPool".equals(fieldName)) {
                    deserializedRunNotebookRequest.sparkPool = reader.getString();
                    continue;
                }
                if ("sessionOptions".equals(fieldName)) {
                    deserializedRunNotebookRequest.sessionOptions = RunNotebookSparkSessionOptions.fromJson(reader);
                    continue;
                }
                if ("honorSessionTimeToLive".equals(fieldName)) {
                    deserializedRunNotebookRequest.honorSessionTimeToLive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedRunNotebookRequest.parameters = parameters = reader.readMap(reader1 -> RunNotebookParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunNotebookRequest;
        });
    }
}

