/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.PhoenixAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PhoenixLinkedService
extends LinkedService {
    private String type = "Phoenix";
    private Object host;
    private Object port;
    private Object httpPath;
    private PhoenixAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object enableSsl;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostNameCNMismatch;
    private Object allowSelfSignedServerCert;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getHost() {
        return this.host;
    }

    public PhoenixLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public PhoenixLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getHttpPath() {
        return this.httpPath;
    }

    public PhoenixLinkedService setHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public PhoenixAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public PhoenixLinkedService setAuthenticationType(PhoenixAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public PhoenixLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public PhoenixLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getEnableSsl() {
        return this.enableSsl;
    }

    public PhoenixLinkedService setEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object getTrustedCertPath() {
        return this.trustedCertPath;
    }

    public PhoenixLinkedService setTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public PhoenixLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object getAllowHostNameCNMismatch() {
        return this.allowHostNameCNMismatch;
    }

    public PhoenixLinkedService setAllowHostNameCNMismatch(Object allowHostNameCNMismatch) {
        this.allowHostNameCNMismatch = allowHostNameCNMismatch;
        return this;
    }

    public Object getAllowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public PhoenixLinkedService setAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public PhoenixLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public PhoenixLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public PhoenixLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public PhoenixLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public PhoenixLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public PhoenixLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.host != null || this.port != null || this.httpPath != null || this.authenticationType != null || this.username != null || this.password != null || this.enableSsl != null || this.trustedCertPath != null || this.useSystemTrustStore != null || this.allowHostNameCNMismatch != null || this.allowSelfSignedServerCert != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("host", this.host);
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.httpPath != null) {
                jsonWriter.writeUntypedField("httpPath", this.httpPath);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.enableSsl != null) {
                jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
            }
            if (this.trustedCertPath != null) {
                jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            if (this.allowHostNameCNMismatch != null) {
                jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostNameCNMismatch);
            }
            if (this.allowSelfSignedServerCert != null) {
                jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PhoenixLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (PhoenixLinkedService)jsonReader.readObject(reader -> {
            PhoenixLinkedService deserializedPhoenixLinkedService = new PhoenixLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedPhoenixLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedPhoenixLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPhoenixLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedPhoenixLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedPhoenixLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPhoenixLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("host".equals(fieldName)) {
                            deserializedPhoenixLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedPhoenixLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("httpPath".equals(fieldName)) {
                            deserializedPhoenixLinkedService.httpPath = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedPhoenixLinkedService.authenticationType = PhoenixAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedPhoenixLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedPhoenixLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("enableSsl".equals(fieldName)) {
                            deserializedPhoenixLinkedService.enableSsl = reader.readUntyped();
                            continue;
                        }
                        if ("trustedCertPath".equals(fieldName)) {
                            deserializedPhoenixLinkedService.trustedCertPath = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedPhoenixLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("allowHostNameCNMismatch".equals(fieldName)) {
                            deserializedPhoenixLinkedService.allowHostNameCNMismatch = reader.readUntyped();
                            continue;
                        }
                        if ("allowSelfSignedServerCert".equals(fieldName)) {
                            deserializedPhoenixLinkedService.allowSelfSignedServerCert = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedPhoenixLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPhoenixLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedPhoenixLinkedService;
        });
    }
}

