/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.NotebookCellOutputItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class NotebookCell
implements JsonSerializable<NotebookCell> {
    private String cellType;
    private Object metadata;
    private List<String> source;
    private Object attachments;
    private List<NotebookCellOutputItem> outputs;
    private Map<String, Object> additionalProperties;

    public String getCellType() {
        return this.cellType;
    }

    public NotebookCell setCellType(String cellType) {
        this.cellType = cellType;
        return this;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public NotebookCell setMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<String> getSource() {
        return this.source;
    }

    public NotebookCell setSource(List<String> source) {
        this.source = source;
        return this;
    }

    public Object getAttachments() {
        return this.attachments;
    }

    public NotebookCell setAttachments(Object attachments) {
        this.attachments = attachments;
        return this;
    }

    public List<NotebookCellOutputItem> getOutputs() {
        return this.outputs;
    }

    public NotebookCell setOutputs(List<NotebookCellOutputItem> outputs) {
        this.outputs = outputs;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public NotebookCell setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cell_type", this.cellType);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeArrayField("source", this.source, (writer, element) -> writer.writeString(element));
        if (this.attachments != null) {
            jsonWriter.writeUntypedField("attachments", this.attachments);
        }
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static NotebookCell fromJson(JsonReader jsonReader) throws IOException {
        return (NotebookCell)jsonReader.readObject(reader -> {
            NotebookCell deserializedNotebookCell = new NotebookCell();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cell_type".equals(fieldName)) {
                    deserializedNotebookCell.cellType = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedNotebookCell.metadata = reader.readUntyped();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    List source;
                    deserializedNotebookCell.source = source = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    deserializedNotebookCell.attachments = reader.readUntyped();
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    List outputs;
                    deserializedNotebookCell.outputs = outputs = reader.readArray(reader1 -> NotebookCellOutputItem.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedNotebookCell.additionalProperties = additionalProperties;
            return deserializedNotebookCell;
        });
    }
}

