/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MongoDbAtlasLinkedService
extends LinkedService {
    private String type = "MongoDbAtlas";
    private Object connectionString;
    private Object database;
    private Object driverVersion;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public MongoDbAtlasLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public MongoDbAtlasLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getDriverVersion() {
        return this.driverVersion;
    }

    public MongoDbAtlasLinkedService setDriverVersion(Object driverVersion) {
        this.driverVersion = driverVersion;
        return this;
    }

    @Override
    public MongoDbAtlasLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public MongoDbAtlasLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public MongoDbAtlasLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MongoDbAtlasLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public MongoDbAtlasLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.database != null || this.driverVersion != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
            jsonWriter.writeUntypedField("database", this.database);
            if (this.driverVersion != null) {
                jsonWriter.writeUntypedField("driverVersion", this.driverVersion);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MongoDbAtlasLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbAtlasLinkedService)jsonReader.readObject(reader -> {
            MongoDbAtlasLinkedService deserializedMongoDbAtlasLinkedService = new MongoDbAtlasLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedMongoDbAtlasLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedMongoDbAtlasLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMongoDbAtlasLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedMongoDbAtlasLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMongoDbAtlasLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbAtlasLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedMongoDbAtlasLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedMongoDbAtlasLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("driverVersion".equals(fieldName)) {
                            deserializedMongoDbAtlasLinkedService.driverVersion = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMongoDbAtlasLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedMongoDbAtlasLinkedService;
        });
    }
}

