/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.LinkTableRequestSource;
import com.azure.analytics.synapse.artifacts.models.LinkTableRequestTarget;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LinkTableRequest
implements JsonSerializable<LinkTableRequest> {
    private String id;
    private LinkTableRequestSource source;
    private LinkTableRequestTarget target;
    private String operationType;

    public String getId() {
        return this.id;
    }

    public LinkTableRequest setId(String id) {
        this.id = id;
        return this;
    }

    public LinkTableRequestSource getSource() {
        return this.source;
    }

    public LinkTableRequest setSource(LinkTableRequestSource source) {
        this.source = source;
        return this;
    }

    public LinkTableRequestTarget getTarget() {
        return this.target;
    }

    public LinkTableRequest setTarget(LinkTableRequestTarget target) {
        this.target = target;
        return this;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public LinkTableRequest setOperationType(String operationType) {
        this.operationType = operationType;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        jsonWriter.writeStringField("operationType", this.operationType);
        return jsonWriter.writeEndObject();
    }

    public static LinkTableRequest fromJson(JsonReader jsonReader) throws IOException {
        return (LinkTableRequest)jsonReader.readObject(reader -> {
            LinkTableRequest deserializedLinkTableRequest = new LinkTableRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkTableRequest.id = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedLinkTableRequest.source = LinkTableRequestSource.fromJson(reader);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedLinkTableRequest.target = LinkTableRequestTarget.fromJson(reader);
                    continue;
                }
                if ("operationType".equals(fieldName)) {
                    deserializedLinkTableRequest.operationType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkTableRequest;
        });
    }
}

