/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureDatabricksDeltaLakeImportCommand;
import com.azure.analytics.synapse.artifacts.models.SnowflakeImportCopyCommand;
import com.azure.analytics.synapse.artifacts.models.TeradataImportCommand;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ImportSettings
implements JsonSerializable<ImportSettings> {
    private String type = "ImportSettings";
    private Map<String, Object> additionalProperties;

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ImportSettings setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ImportSettings fromJson(JsonReader jsonReader) throws IOException {
        return (ImportSettings)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ImportSettings importSettings;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("TeradataImportCommand".equals(discriminatorValue)) {
                    importSettings = TeradataImportCommand.fromJson(readerToUse.reset());
                    return importSettings;
                }
                if ("AzureDatabricksDeltaLakeImportCommand".equals(discriminatorValue)) {
                    importSettings = AzureDatabricksDeltaLakeImportCommand.fromJson(readerToUse.reset());
                    return importSettings;
                }
                if ("SnowflakeImportCopyCommand".equals(discriminatorValue)) {
                    importSettings = SnowflakeImportCopyCommand.fromJson(readerToUse.reset());
                    return importSettings;
                }
                importSettings = ImportSettings.fromJsonKnownDiscriminator(readerToUse.reset());
                return importSettings;
            }
        });
    }

    static ImportSettings fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ImportSettings)jsonReader.readObject(reader -> {
            ImportSettings deserializedImportSettings = new ImportSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedImportSettings.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedImportSettings.additionalProperties = additionalProperties;
            return deserializedImportSettings;
        });
    }
}

