/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.HiveAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.HiveServerType;
import com.azure.analytics.synapse.artifacts.models.HiveThriftTransportProtocol;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HiveLinkedService
extends LinkedService {
    private String type = "Hive";
    private Object host;
    private Object port;
    private HiveServerType serverType;
    private HiveThriftTransportProtocol thriftTransportProtocol;
    private HiveAuthenticationType authenticationType;
    private Object serviceDiscoveryMode;
    private Object zooKeeperNameSpace;
    private Object useNativeQuery;
    private Object username;
    private SecretBase password;
    private Object httpPath;
    private Object enableSsl;
    private Object enableServerCertificateValidation;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostNameCNMismatch;
    private Object allowSelfSignedServerCert;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getHost() {
        return this.host;
    }

    public HiveLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public HiveLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public HiveServerType getServerType() {
        return this.serverType;
    }

    public HiveLinkedService setServerType(HiveServerType serverType) {
        this.serverType = serverType;
        return this;
    }

    public HiveThriftTransportProtocol getThriftTransportProtocol() {
        return this.thriftTransportProtocol;
    }

    public HiveLinkedService setThriftTransportProtocol(HiveThriftTransportProtocol thriftTransportProtocol) {
        this.thriftTransportProtocol = thriftTransportProtocol;
        return this;
    }

    public HiveAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public HiveLinkedService setAuthenticationType(HiveAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getServiceDiscoveryMode() {
        return this.serviceDiscoveryMode;
    }

    public HiveLinkedService setServiceDiscoveryMode(Object serviceDiscoveryMode) {
        this.serviceDiscoveryMode = serviceDiscoveryMode;
        return this;
    }

    public Object getZooKeeperNameSpace() {
        return this.zooKeeperNameSpace;
    }

    public HiveLinkedService setZooKeeperNameSpace(Object zooKeeperNameSpace) {
        this.zooKeeperNameSpace = zooKeeperNameSpace;
        return this;
    }

    public Object getUseNativeQuery() {
        return this.useNativeQuery;
    }

    public HiveLinkedService setUseNativeQuery(Object useNativeQuery) {
        this.useNativeQuery = useNativeQuery;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public HiveLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public HiveLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getHttpPath() {
        return this.httpPath;
    }

    public HiveLinkedService setHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public Object getEnableSsl() {
        return this.enableSsl;
    }

    public HiveLinkedService setEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object getEnableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public HiveLinkedService setEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public Object getTrustedCertPath() {
        return this.trustedCertPath;
    }

    public HiveLinkedService setTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public HiveLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object getAllowHostNameCNMismatch() {
        return this.allowHostNameCNMismatch;
    }

    public HiveLinkedService setAllowHostNameCNMismatch(Object allowHostNameCNMismatch) {
        this.allowHostNameCNMismatch = allowHostNameCNMismatch;
        return this;
    }

    public Object getAllowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public HiveLinkedService setAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public HiveLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public HiveLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public HiveLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public HiveLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HiveLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public HiveLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.host != null || this.port != null || this.serverType != null || this.thriftTransportProtocol != null || this.authenticationType != null || this.serviceDiscoveryMode != null || this.zooKeeperNameSpace != null || this.useNativeQuery != null || this.username != null || this.password != null || this.httpPath != null || this.enableSsl != null || this.enableServerCertificateValidation != null || this.trustedCertPath != null || this.useSystemTrustStore != null || this.allowHostNameCNMismatch != null || this.allowSelfSignedServerCert != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("host", this.host);
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            jsonWriter.writeStringField("serverType", this.serverType == null ? null : this.serverType.toString());
            jsonWriter.writeStringField("thriftTransportProtocol", this.thriftTransportProtocol == null ? null : this.thriftTransportProtocol.toString());
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.serviceDiscoveryMode != null) {
                jsonWriter.writeUntypedField("serviceDiscoveryMode", this.serviceDiscoveryMode);
            }
            if (this.zooKeeperNameSpace != null) {
                jsonWriter.writeUntypedField("zooKeeperNameSpace", this.zooKeeperNameSpace);
            }
            if (this.useNativeQuery != null) {
                jsonWriter.writeUntypedField("useNativeQuery", this.useNativeQuery);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.httpPath != null) {
                jsonWriter.writeUntypedField("httpPath", this.httpPath);
            }
            if (this.enableSsl != null) {
                jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
            }
            if (this.enableServerCertificateValidation != null) {
                jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
            }
            if (this.trustedCertPath != null) {
                jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            if (this.allowHostNameCNMismatch != null) {
                jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostNameCNMismatch);
            }
            if (this.allowSelfSignedServerCert != null) {
                jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HiveLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (HiveLinkedService)jsonReader.readObject(reader -> {
            HiveLinkedService deserializedHiveLinkedService = new HiveLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedHiveLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedHiveLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHiveLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedHiveLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedHiveLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHiveLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("host".equals(fieldName)) {
                            deserializedHiveLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedHiveLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("serverType".equals(fieldName)) {
                            deserializedHiveLinkedService.serverType = HiveServerType.fromString(reader.getString());
                            continue;
                        }
                        if ("thriftTransportProtocol".equals(fieldName)) {
                            deserializedHiveLinkedService.thriftTransportProtocol = HiveThriftTransportProtocol.fromString(reader.getString());
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedHiveLinkedService.authenticationType = HiveAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("serviceDiscoveryMode".equals(fieldName)) {
                            deserializedHiveLinkedService.serviceDiscoveryMode = reader.readUntyped();
                            continue;
                        }
                        if ("zooKeeperNameSpace".equals(fieldName)) {
                            deserializedHiveLinkedService.zooKeeperNameSpace = reader.readUntyped();
                            continue;
                        }
                        if ("useNativeQuery".equals(fieldName)) {
                            deserializedHiveLinkedService.useNativeQuery = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedHiveLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedHiveLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("httpPath".equals(fieldName)) {
                            deserializedHiveLinkedService.httpPath = reader.readUntyped();
                            continue;
                        }
                        if ("enableSsl".equals(fieldName)) {
                            deserializedHiveLinkedService.enableSsl = reader.readUntyped();
                            continue;
                        }
                        if ("enableServerCertificateValidation".equals(fieldName)) {
                            deserializedHiveLinkedService.enableServerCertificateValidation = reader.readUntyped();
                            continue;
                        }
                        if ("trustedCertPath".equals(fieldName)) {
                            deserializedHiveLinkedService.trustedCertPath = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedHiveLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("allowHostNameCNMismatch".equals(fieldName)) {
                            deserializedHiveLinkedService.allowHostNameCNMismatch = reader.readUntyped();
                            continue;
                        }
                        if ("allowSelfSignedServerCert".equals(fieldName)) {
                            deserializedHiveLinkedService.allowSelfSignedServerCert = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedHiveLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHiveLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedHiveLinkedService;
        });
    }
}

