/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightActivityDebugInfoOption;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HDInsightHiveActivity
extends ExecutionActivity {
    private String type = "HDInsightHive";
    private List<LinkedServiceReference> storageLinkedServices;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private Object scriptPath;
    private LinkedServiceReference scriptLinkedService;
    private Map<String, Object> defines;
    private List<Object> variables;
    private Integer queryTimeout;

    @Override
    public String getType() {
        return this.type;
    }

    public List<LinkedServiceReference> getStorageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightHiveActivity setStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public HDInsightHiveActivity setArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getGetDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightHiveActivity setGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object getScriptPath() {
        return this.scriptPath;
    }

    public HDInsightHiveActivity setScriptPath(Object scriptPath) {
        this.scriptPath = scriptPath;
        return this;
    }

    public LinkedServiceReference getScriptLinkedService() {
        return this.scriptLinkedService;
    }

    public HDInsightHiveActivity setScriptLinkedService(LinkedServiceReference scriptLinkedService) {
        this.scriptLinkedService = scriptLinkedService;
        return this;
    }

    public Map<String, Object> getDefines() {
        return this.defines;
    }

    public HDInsightHiveActivity setDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    public List<Object> getVariables() {
        return this.variables;
    }

    public HDInsightHiveActivity setVariables(List<Object> variables) {
        this.variables = variables;
        return this;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public HDInsightHiveActivity setQueryTimeout(Integer queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public HDInsightHiveActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightHiveActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public HDInsightHiveActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public HDInsightHiveActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HDInsightHiveActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public HDInsightHiveActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public HDInsightHiveActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightHiveActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.storageLinkedServices != null || this.arguments != null || this.getDebugInfo != null || this.scriptPath != null || this.scriptLinkedService != null || this.defines != null || this.variables != null || this.queryTimeout != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeArrayField("storageLinkedServices", this.storageLinkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
            if (this.scriptPath != null) {
                jsonWriter.writeUntypedField("scriptPath", this.scriptPath);
            }
            jsonWriter.writeJsonField("scriptLinkedService", (JsonSerializable)this.scriptLinkedService);
            jsonWriter.writeMapField("defines", this.defines, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeArrayField("variables", this.variables, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeNumberField("queryTimeout", (Number)this.queryTimeout);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightHiveActivity fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightHiveActivity)jsonReader.readObject(reader -> {
            HDInsightHiveActivity deserializedHDInsightHiveActivity = new HDInsightHiveActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHDInsightHiveActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightHiveActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedHDInsightHiveActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedHDInsightHiveActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedHDInsightHiveActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedHDInsightHiveActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightHiveActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedHDInsightHiveActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightHiveActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("storageLinkedServices".equals(fieldName)) {
                            List storageLinkedServices;
                            deserializedHDInsightHiveActivity.storageLinkedServices = storageLinkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                            continue;
                        }
                        if ("arguments".equals(fieldName)) {
                            List arguments;
                            deserializedHDInsightHiveActivity.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("getDebugInfo".equals(fieldName)) {
                            deserializedHDInsightHiveActivity.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                            continue;
                        }
                        if ("scriptPath".equals(fieldName)) {
                            deserializedHDInsightHiveActivity.scriptPath = reader.readUntyped();
                            continue;
                        }
                        if ("scriptLinkedService".equals(fieldName)) {
                            deserializedHDInsightHiveActivity.scriptLinkedService = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("defines".equals(fieldName)) {
                            Map defines;
                            deserializedHDInsightHiveActivity.defines = defines = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("variables".equals(fieldName)) {
                            List variables;
                            deserializedHDInsightHiveActivity.variables = variables = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("queryTimeout".equals(fieldName)) {
                            deserializedHDInsightHiveActivity.queryTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightHiveActivity.setAdditionalProperties(additionalProperties);
            return deserializedHDInsightHiveActivity;
        });
    }
}

