/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GoogleCloudStorageLinkedService
extends LinkedService {
    private String type = "GoogleCloudStorage";
    private Object accessKeyId;
    private SecretBase secretAccessKey;
    private Object serviceUrl;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getAccessKeyId() {
        return this.accessKeyId;
    }

    public GoogleCloudStorageLinkedService setAccessKeyId(Object accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public SecretBase getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public GoogleCloudStorageLinkedService setSecretAccessKey(SecretBase secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    public Object getServiceUrl() {
        return this.serviceUrl;
    }

    public GoogleCloudStorageLinkedService setServiceUrl(Object serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleCloudStorageLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public GoogleCloudStorageLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public GoogleCloudStorageLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public GoogleCloudStorageLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public GoogleCloudStorageLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public GoogleCloudStorageLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.accessKeyId != null || this.secretAccessKey != null || this.serviceUrl != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.accessKeyId != null) {
                jsonWriter.writeUntypedField("accessKeyId", this.accessKeyId);
            }
            jsonWriter.writeJsonField("secretAccessKey", (JsonSerializable)this.secretAccessKey);
            if (this.serviceUrl != null) {
                jsonWriter.writeUntypedField("serviceUrl", this.serviceUrl);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleCloudStorageLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleCloudStorageLinkedService)jsonReader.readObject(reader -> {
            GoogleCloudStorageLinkedService deserializedGoogleCloudStorageLinkedService = new GoogleCloudStorageLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGoogleCloudStorageLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGoogleCloudStorageLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleCloudStorageLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("accessKeyId".equals(fieldName)) {
                            deserializedGoogleCloudStorageLinkedService.accessKeyId = reader.readUntyped();
                            continue;
                        }
                        if ("secretAccessKey".equals(fieldName)) {
                            deserializedGoogleCloudStorageLinkedService.secretAccessKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("serviceUrl".equals(fieldName)) {
                            deserializedGoogleCloudStorageLinkedService.serviceUrl = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedGoogleCloudStorageLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleCloudStorageLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedGoogleCloudStorageLinkedService;
        });
    }
}

