/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureDatabricksDeltaLakeExportCommand;
import com.azure.analytics.synapse.artifacts.models.SnowflakeExportCopyCommand;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExportSettings
implements JsonSerializable<ExportSettings> {
    private String type = "ExportSettings";
    private Map<String, Object> additionalProperties;

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ExportSettings setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExportSettings fromJson(JsonReader jsonReader) throws IOException {
        return (ExportSettings)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ExportSettings exportSettings;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("SnowflakeExportCopyCommand".equals(discriminatorValue)) {
                    exportSettings = SnowflakeExportCopyCommand.fromJson(readerToUse.reset());
                    return exportSettings;
                }
                if ("AzureDatabricksDeltaLakeExportCommand".equals(discriminatorValue)) {
                    exportSettings = AzureDatabricksDeltaLakeExportCommand.fromJson(readerToUse.reset());
                    return exportSettings;
                }
                exportSettings = ExportSettings.fromJsonKnownDiscriminator(readerToUse.reset());
                return exportSettings;
            }
        });
    }

    static ExportSettings fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ExportSettings)jsonReader.readObject(reader -> {
            ExportSettings deserializedExportSettings = new ExportSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExportSettings.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExportSettings.additionalProperties = additionalProperties;
            return deserializedExportSettings;
        });
    }
}

