/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DynamicsLinkedService
extends LinkedService {
    private String type = "Dynamics";
    private Object deploymentType;
    private Object hostName;
    private Object port;
    private Object serviceUri;
    private Object organizationName;
    private Object authenticationType;
    private Object domain;
    private Object username;
    private SecretBase password;
    private Object servicePrincipalId;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object encryptedCredential;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getDeploymentType() {
        return this.deploymentType;
    }

    public DynamicsLinkedService setDeploymentType(Object deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public Object getHostName() {
        return this.hostName;
    }

    public DynamicsLinkedService setHostName(Object hostName) {
        this.hostName = hostName;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public DynamicsLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getServiceUri() {
        return this.serviceUri;
    }

    public DynamicsLinkedService setServiceUri(Object serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Object getOrganizationName() {
        return this.organizationName;
    }

    public DynamicsLinkedService setOrganizationName(Object organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public Object getAuthenticationType() {
        return this.authenticationType;
    }

    public DynamicsLinkedService setAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getDomain() {
        return this.domain;
    }

    public DynamicsLinkedService setDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public DynamicsLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public DynamicsLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public DynamicsLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public DynamicsLinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public DynamicsLinkedService setServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public DynamicsLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public DynamicsLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public DynamicsLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public DynamicsLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public DynamicsLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DynamicsLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public DynamicsLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.deploymentType != null || this.hostName != null || this.port != null || this.serviceUri != null || this.organizationName != null || this.authenticationType != null || this.domain != null || this.username != null || this.password != null || this.servicePrincipalId != null || this.servicePrincipalCredentialType != null || this.servicePrincipalCredential != null || this.encryptedCredential != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("deploymentType", this.deploymentType);
            if (this.hostName != null) {
                jsonWriter.writeUntypedField("hostName", this.hostName);
            }
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.serviceUri != null) {
                jsonWriter.writeUntypedField("serviceUri", this.serviceUri);
            }
            if (this.organizationName != null) {
                jsonWriter.writeUntypedField("organizationName", this.organizationName);
            }
            jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
            if (this.domain != null) {
                jsonWriter.writeUntypedField("domain", this.domain);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DynamicsLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicsLinkedService)jsonReader.readObject(reader -> {
            DynamicsLinkedService deserializedDynamicsLinkedService = new DynamicsLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedDynamicsLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedDynamicsLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDynamicsLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedDynamicsLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedDynamicsLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDynamicsLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("deploymentType".equals(fieldName)) {
                            deserializedDynamicsLinkedService.deploymentType = reader.readUntyped();
                            continue;
                        }
                        if ("hostName".equals(fieldName)) {
                            deserializedDynamicsLinkedService.hostName = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedDynamicsLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("serviceUri".equals(fieldName)) {
                            deserializedDynamicsLinkedService.serviceUri = reader.readUntyped();
                            continue;
                        }
                        if ("organizationName".equals(fieldName)) {
                            deserializedDynamicsLinkedService.organizationName = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedDynamicsLinkedService.authenticationType = reader.readUntyped();
                            continue;
                        }
                        if ("domain".equals(fieldName)) {
                            deserializedDynamicsLinkedService.domain = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedDynamicsLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedDynamicsLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedDynamicsLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedDynamicsLinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredential".equals(fieldName)) {
                            deserializedDynamicsLinkedService.servicePrincipalCredential = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedDynamicsLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedDynamicsLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDynamicsLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedDynamicsLinkedService;
        });
    }
}

