/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowReference;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.Transformation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DataFlowSink
extends Transformation {
    private LinkedServiceReference schemaLinkedService;
    private LinkedServiceReference rejectedDataLinkedService;

    public LinkedServiceReference getSchemaLinkedService() {
        return this.schemaLinkedService;
    }

    public DataFlowSink setSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        this.schemaLinkedService = schemaLinkedService;
        return this;
    }

    public LinkedServiceReference getRejectedDataLinkedService() {
        return this.rejectedDataLinkedService;
    }

    public DataFlowSink setRejectedDataLinkedService(LinkedServiceReference rejectedDataLinkedService) {
        this.rejectedDataLinkedService = rejectedDataLinkedService;
        return this;
    }

    @Override
    public DataFlowSink setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DataFlowSink setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DataFlowSink setDataset(DatasetReference dataset) {
        super.setDataset(dataset);
        return this;
    }

    @Override
    public DataFlowSink setLinkedService(LinkedServiceReference linkedService) {
        super.setLinkedService(linkedService);
        return this;
    }

    @Override
    public DataFlowSink setFlowlet(DataFlowReference flowlet) {
        super.setFlowlet(flowlet);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.getDataset());
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.getLinkedService());
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.getFlowlet());
        jsonWriter.writeJsonField("schemaLinkedService", (JsonSerializable)this.schemaLinkedService);
        jsonWriter.writeJsonField("rejectedDataLinkedService", (JsonSerializable)this.rejectedDataLinkedService);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowSink fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowSink)jsonReader.readObject(reader -> {
            DataFlowSink deserializedDataFlowSink = new DataFlowSink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataFlowSink.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataFlowSink.setDescription(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedDataFlowSink.setDataset(DatasetReference.fromJson(reader));
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedDataFlowSink.setLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedDataFlowSink.setFlowlet(DataFlowReference.fromJson(reader));
                    continue;
                }
                if ("schemaLinkedService".equals(fieldName)) {
                    deserializedDataFlowSink.schemaLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("rejectedDataLinkedService".equals(fieldName)) {
                    deserializedDataFlowSink.rejectedDataLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowSink;
        });
    }
}

