/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CosmosDbSqlApiSource
extends CopySource {
    private String type = "CosmosDbSqlApiSource";
    private Object query;
    private Object pageSize;
    private Object preferredRegions;
    private Object detectDatetime;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public CosmosDbSqlApiSource setQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object getPageSize() {
        return this.pageSize;
    }

    public CosmosDbSqlApiSource setPageSize(Object pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Object getPreferredRegions() {
        return this.preferredRegions;
    }

    public CosmosDbSqlApiSource setPreferredRegions(Object preferredRegions) {
        this.preferredRegions = preferredRegions;
        return this;
    }

    public Object getDetectDatetime() {
        return this.detectDatetime;
    }

    public CosmosDbSqlApiSource setDetectDatetime(Object detectDatetime) {
        this.detectDatetime = detectDatetime;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public CosmosDbSqlApiSource setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public CosmosDbSqlApiSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public CosmosDbSqlApiSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public CosmosDbSqlApiSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.pageSize != null) {
            jsonWriter.writeUntypedField("pageSize", this.pageSize);
        }
        if (this.preferredRegions != null) {
            jsonWriter.writeUntypedField("preferredRegions", this.preferredRegions);
        }
        if (this.detectDatetime != null) {
            jsonWriter.writeUntypedField("detectDatetime", this.detectDatetime);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbSqlApiSource fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbSqlApiSource)jsonReader.readObject(reader -> {
            CosmosDbSqlApiSource deserializedCosmosDbSqlApiSource = new CosmosDbSqlApiSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.query = reader.readUntyped();
                    continue;
                }
                if ("pageSize".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.pageSize = reader.readUntyped();
                    continue;
                }
                if ("preferredRegions".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.preferredRegions = reader.readUntyped();
                    continue;
                }
                if ("detectDatetime".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.detectDatetime = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedCosmosDbSqlApiSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCosmosDbSqlApiSource.setAdditionalProperties(additionalProperties);
            return deserializedCosmosDbSqlApiSource;
        });
    }
}

