/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CommonDataServiceForAppsEntityDataset
extends Dataset {
    private String type = "CommonDataServiceForAppsEntity";
    private Object entityName;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEntityName() {
        return this.entityName;
    }

    public CommonDataServiceForAppsEntityDataset setEntityName(Object entityName) {
        this.entityName = entityName;
        return this;
    }

    @Override
    public CommonDataServiceForAppsEntityDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CommonDataServiceForAppsEntityDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public CommonDataServiceForAppsEntityDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public CommonDataServiceForAppsEntityDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CommonDataServiceForAppsEntityDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public CommonDataServiceForAppsEntityDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public CommonDataServiceForAppsEntityDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.entityName != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.entityName != null) {
                jsonWriter.writeUntypedField("entityName", this.entityName);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CommonDataServiceForAppsEntityDataset fromJson(JsonReader jsonReader) throws IOException {
        return (CommonDataServiceForAppsEntityDataset)jsonReader.readObject(reader -> {
            CommonDataServiceForAppsEntityDataset deserializedCommonDataServiceForAppsEntityDataset = new CommonDataServiceForAppsEntityDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsEntityDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsEntityDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsEntityDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsEntityDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedCommonDataServiceForAppsEntityDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedCommonDataServiceForAppsEntityDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsEntityDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsEntityDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("entityName".equals(fieldName)) {
                            deserializedCommonDataServiceForAppsEntityDataset.entityName = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCommonDataServiceForAppsEntityDataset.setAdditionalProperties(additionalProperties);
            return deserializedCommonDataServiceForAppsEntityDataset;
        });
    }
}

