/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CassandraTableDataset
extends Dataset {
    private String type = "CassandraTable";
    private Object tableName;
    private Object keyspace;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTableName() {
        return this.tableName;
    }

    public CassandraTableDataset setTableName(Object tableName) {
        this.tableName = tableName;
        return this;
    }

    public Object getKeyspace() {
        return this.keyspace;
    }

    public CassandraTableDataset setKeyspace(Object keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    @Override
    public CassandraTableDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CassandraTableDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public CassandraTableDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public CassandraTableDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CassandraTableDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public CassandraTableDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public CassandraTableDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.tableName != null || this.keyspace != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.tableName != null) {
                jsonWriter.writeUntypedField("tableName", this.tableName);
            }
            if (this.keyspace != null) {
                jsonWriter.writeUntypedField("keyspace", this.keyspace);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CassandraTableDataset fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraTableDataset)jsonReader.readObject(reader -> {
            CassandraTableDataset deserializedCassandraTableDataset = new CassandraTableDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedCassandraTableDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCassandraTableDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedCassandraTableDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedCassandraTableDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedCassandraTableDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedCassandraTableDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedCassandraTableDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCassandraTableDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("tableName".equals(fieldName)) {
                            deserializedCassandraTableDataset.tableName = reader.readUntyped();
                            continue;
                        }
                        if ("keyspace".equals(fieldName)) {
                            deserializedCassandraTableDataset.keyspace = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCassandraTableDataset.setAdditionalProperties(additionalProperties);
            return deserializedCassandraTableDataset;
        });
    }
}

