/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CassandraSourceReadConsistencyLevels;
import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CassandraSource
extends TabularSource {
    private String type = "CassandraSource";
    private Object query;
    private CassandraSourceReadConsistencyLevels consistencyLevel;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public CassandraSource setQuery(Object query) {
        this.query = query;
        return this;
    }

    public CassandraSourceReadConsistencyLevels getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public CassandraSource setConsistencyLevel(CassandraSourceReadConsistencyLevels consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public CassandraSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public CassandraSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public CassandraSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public CassandraSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public CassandraSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        jsonWriter.writeStringField("consistencyLevel", this.consistencyLevel == null ? null : this.consistencyLevel.toString());
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CassandraSource fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraSource)jsonReader.readObject(reader -> {
            CassandraSource deserializedCassandraSource = new CassandraSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedCassandraSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedCassandraSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedCassandraSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedCassandraSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedCassandraSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCassandraSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedCassandraSource.query = reader.readUntyped();
                    continue;
                }
                if ("consistencyLevel".equals(fieldName)) {
                    deserializedCassandraSource.consistencyLevel = CassandraSourceReadConsistencyLevels.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCassandraSource.setAdditionalProperties(additionalProperties);
            return deserializedCassandraSource;
        });
    }
}

