/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.BinaryReadSettings;
import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.analytics.synapse.artifacts.models.StoreReadSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BinarySource
extends CopySource {
    private String type = "BinarySource";
    private StoreReadSettings storeSettings;
    private BinaryReadSettings formatSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public StoreReadSettings getStoreSettings() {
        return this.storeSettings;
    }

    public BinarySource setStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public BinaryReadSettings getFormatSettings() {
        return this.formatSettings;
    }

    public BinarySource setFormatSettings(BinaryReadSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    @Override
    public BinarySource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public BinarySource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public BinarySource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
        jsonWriter.writeJsonField("formatSettings", (JsonSerializable)this.formatSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BinarySource fromJson(JsonReader jsonReader) throws IOException {
        return (BinarySource)jsonReader.readObject(reader -> {
            BinarySource deserializedBinarySource = new BinarySource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedBinarySource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedBinarySource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedBinarySource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBinarySource.type = reader.getString();
                    continue;
                }
                if ("storeSettings".equals(fieldName)) {
                    deserializedBinarySource.storeSettings = StoreReadSettings.fromJson(reader);
                    continue;
                }
                if ("formatSettings".equals(fieldName)) {
                    deserializedBinarySource.formatSettings = BinaryReadSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBinarySource.setAdditionalProperties(additionalProperties);
            return deserializedBinarySource;
        });
    }
}

