/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzurePostgreSqlLinkedService
extends LinkedService {
    private String type = "AzurePostgreSql";
    private Object connectionString;
    private Object server;
    private Object port;
    private Object username;
    private Object database;
    private Object sslMode;
    private Object timeout;
    private Object commandTimeout;
    private Object trustServerCertificate;
    private Object readBufferSize;
    private Object timezone;
    private Object encoding;
    private AzureKeyVaultSecretReference password;
    private Object encryptedCredential;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;
    private Object tenant;
    private Object azureCloudType;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public AzurePostgreSqlLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getServer() {
        return this.server;
    }

    public AzurePostgreSqlLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public AzurePostgreSqlLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public AzurePostgreSqlLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public AzurePostgreSqlLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getSslMode() {
        return this.sslMode;
    }

    public AzurePostgreSqlLinkedService setSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object getTimeout() {
        return this.timeout;
    }

    public AzurePostgreSqlLinkedService setTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    public Object getCommandTimeout() {
        return this.commandTimeout;
    }

    public AzurePostgreSqlLinkedService setCommandTimeout(Object commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public Object getTrustServerCertificate() {
        return this.trustServerCertificate;
    }

    public AzurePostgreSqlLinkedService setTrustServerCertificate(Object trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public Object getReadBufferSize() {
        return this.readBufferSize;
    }

    public AzurePostgreSqlLinkedService setReadBufferSize(Object readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public Object getTimezone() {
        return this.timezone;
    }

    public AzurePostgreSqlLinkedService setTimezone(Object timezone) {
        this.timezone = timezone;
        return this;
    }

    public Object getEncoding() {
        return this.encoding;
    }

    public AzurePostgreSqlLinkedService setEncoding(Object encoding) {
        this.encoding = encoding;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public AzurePostgreSqlLinkedService setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzurePostgreSqlLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzurePostgreSqlLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzurePostgreSqlLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzurePostgreSqlLinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public AzurePostgreSqlLinkedService setServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public AzurePostgreSqlLinkedService setServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzurePostgreSqlLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public AzurePostgreSqlLinkedService setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzurePostgreSqlLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzurePostgreSqlLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzurePostgreSqlLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzurePostgreSqlLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzurePostgreSqlLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzurePostgreSqlLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.server != null || this.port != null || this.username != null || this.database != null || this.sslMode != null || this.timeout != null || this.commandTimeout != null || this.trustServerCertificate != null || this.readBufferSize != null || this.timezone != null || this.encoding != null || this.password != null || this.encryptedCredential != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.servicePrincipalCredentialType != null || this.servicePrincipalEmbeddedCert != null || this.servicePrincipalEmbeddedCertPassword != null || this.tenant != null || this.azureCloudType != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            if (this.server != null) {
                jsonWriter.writeUntypedField("server", this.server);
            }
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            if (this.sslMode != null) {
                jsonWriter.writeUntypedField("sslMode", this.sslMode);
            }
            if (this.timeout != null) {
                jsonWriter.writeUntypedField("timeout", this.timeout);
            }
            if (this.commandTimeout != null) {
                jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout);
            }
            if (this.trustServerCertificate != null) {
                jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate);
            }
            if (this.readBufferSize != null) {
                jsonWriter.writeUntypedField("readBufferSize", this.readBufferSize);
            }
            if (this.timezone != null) {
                jsonWriter.writeUntypedField("timezone", this.timezone);
            }
            if (this.encoding != null) {
                jsonWriter.writeUntypedField("encoding", this.encoding);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.azureCloudType != null) {
                jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzurePostgreSqlLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzurePostgreSqlLinkedService)jsonReader.readObject(reader -> {
            AzurePostgreSqlLinkedService deserializedAzurePostgreSqlLinkedService = new AzurePostgreSqlLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzurePostgreSqlLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzurePostgreSqlLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzurePostgreSqlLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzurePostgreSqlLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzurePostgreSqlLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzurePostgreSqlLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("server".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("sslMode".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.sslMode = reader.readUntyped();
                            continue;
                        }
                        if ("timeout".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.timeout = reader.readUntyped();
                            continue;
                        }
                        if ("commandTimeout".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.commandTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("trustServerCertificate".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.trustServerCertificate = reader.readUntyped();
                            continue;
                        }
                        if ("readBufferSize".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.readBufferSize = reader.readUntyped();
                            continue;
                        }
                        if ("timezone".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.timezone = reader.readUntyped();
                            continue;
                        }
                        if ("encoding".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.encoding = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.password = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("azureCloudType".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.azureCloudType = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzurePostgreSqlLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzurePostgreSqlLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzurePostgreSqlLinkedService;
        });
    }
}

