/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureMLLinkedService
extends LinkedService {
    private String type = "AzureML";
    private Object mlEndpoint;
    private SecretBase apiKey;
    private Object updateResourceEndpoint;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object encryptedCredential;
    private Object authentication;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getMlEndpoint() {
        return this.mlEndpoint;
    }

    public AzureMLLinkedService setMlEndpoint(Object mlEndpoint) {
        this.mlEndpoint = mlEndpoint;
        return this;
    }

    public SecretBase getApiKey() {
        return this.apiKey;
    }

    public AzureMLLinkedService setApiKey(SecretBase apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public Object getUpdateResourceEndpoint() {
        return this.updateResourceEndpoint;
    }

    public AzureMLLinkedService setUpdateResourceEndpoint(Object updateResourceEndpoint) {
        this.updateResourceEndpoint = updateResourceEndpoint;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureMLLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureMLLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureMLLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureMLLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getAuthentication() {
        return this.authentication;
    }

    public AzureMLLinkedService setAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public AzureMLLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureMLLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureMLLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureMLLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureMLLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.mlEndpoint != null || this.apiKey != null || this.updateResourceEndpoint != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.tenant != null || this.encryptedCredential != null || this.authentication != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("mlEndpoint", this.mlEndpoint);
            jsonWriter.writeJsonField("apiKey", (JsonSerializable)this.apiKey);
            if (this.updateResourceEndpoint != null) {
                jsonWriter.writeUntypedField("updateResourceEndpoint", this.updateResourceEndpoint);
            }
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.authentication != null) {
                jsonWriter.writeUntypedField("authentication", this.authentication);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureMLLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLLinkedService)jsonReader.readObject(reader -> {
            AzureMLLinkedService deserializedAzureMLLinkedService = new AzureMLLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureMLLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureMLLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureMLLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureMLLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureMLLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMLLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("mlEndpoint".equals(fieldName)) {
                            deserializedAzureMLLinkedService.mlEndpoint = reader.readUntyped();
                            continue;
                        }
                        if ("apiKey".equals(fieldName)) {
                            deserializedAzureMLLinkedService.apiKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("updateResourceEndpoint".equals(fieldName)) {
                            deserializedAzureMLLinkedService.updateResourceEndpoint = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzureMLLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzureMLLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzureMLLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureMLLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedAzureMLLinkedService.authentication = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureMLLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureMLLinkedService;
        });
    }
}

