/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureMLExecutePipelineActivity
extends ExecutionActivity {
    private String type = "AzureMLExecutePipeline";
    private Object mlPipelineId;
    private Object experimentName;
    private Object mlPipelineParameters;
    private Object mlParentRunId;
    private Object continueOnStepFailure;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getMlPipelineId() {
        return this.mlPipelineId;
    }

    public AzureMLExecutePipelineActivity setMlPipelineId(Object mlPipelineId) {
        this.mlPipelineId = mlPipelineId;
        return this;
    }

    public Object getExperimentName() {
        return this.experimentName;
    }

    public AzureMLExecutePipelineActivity setExperimentName(Object experimentName) {
        this.experimentName = experimentName;
        return this;
    }

    public Object getMlPipelineParameters() {
        return this.mlPipelineParameters;
    }

    public AzureMLExecutePipelineActivity setMlPipelineParameters(Object mlPipelineParameters) {
        this.mlPipelineParameters = mlPipelineParameters;
        return this;
    }

    public Object getMlParentRunId() {
        return this.mlParentRunId;
    }

    public AzureMLExecutePipelineActivity setMlParentRunId(Object mlParentRunId) {
        this.mlParentRunId = mlParentRunId;
        return this;
    }

    public Object getContinueOnStepFailure() {
        return this.continueOnStepFailure;
    }

    public AzureMLExecutePipelineActivity setContinueOnStepFailure(Object continueOnStepFailure) {
        this.continueOnStepFailure = continueOnStepFailure;
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureMLExecutePipelineActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.mlPipelineId != null || this.experimentName != null || this.mlPipelineParameters != null || this.mlParentRunId != null || this.continueOnStepFailure != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("mlPipelineId", this.mlPipelineId);
            if (this.experimentName != null) {
                jsonWriter.writeUntypedField("experimentName", this.experimentName);
            }
            if (this.mlPipelineParameters != null) {
                jsonWriter.writeUntypedField("mlPipelineParameters", this.mlPipelineParameters);
            }
            if (this.mlParentRunId != null) {
                jsonWriter.writeUntypedField("mlParentRunId", this.mlParentRunId);
            }
            if (this.continueOnStepFailure != null) {
                jsonWriter.writeUntypedField("continueOnStepFailure", this.continueOnStepFailure);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureMLExecutePipelineActivity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLExecutePipelineActivity)jsonReader.readObject(reader -> {
            AzureMLExecutePipelineActivity deserializedAzureMLExecutePipelineActivity = new AzureMLExecutePipelineActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedAzureMLExecutePipelineActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedAzureMLExecutePipelineActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMLExecutePipelineActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("mlPipelineId".equals(fieldName)) {
                            deserializedAzureMLExecutePipelineActivity.mlPipelineId = reader.readUntyped();
                            continue;
                        }
                        if ("experimentName".equals(fieldName)) {
                            deserializedAzureMLExecutePipelineActivity.experimentName = reader.readUntyped();
                            continue;
                        }
                        if ("mlPipelineParameters".equals(fieldName)) {
                            deserializedAzureMLExecutePipelineActivity.mlPipelineParameters = reader.readUntyped();
                            continue;
                        }
                        if ("mlParentRunId".equals(fieldName)) {
                            deserializedAzureMLExecutePipelineActivity.mlParentRunId = reader.readUntyped();
                            continue;
                        }
                        if ("continueOnStepFailure".equals(fieldName)) {
                            deserializedAzureMLExecutePipelineActivity.continueOnStepFailure = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureMLExecutePipelineActivity.setAdditionalProperties(additionalProperties);
            return deserializedAzureMLExecutePipelineActivity;
        });
    }
}

