/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureKeyVaultSecretReference
extends SecretBase {
    private String type = "AzureKeyVaultSecret";
    private LinkedServiceReference store;
    private Object secretName;
    private Object secretVersion;

    @Override
    public String getType() {
        return this.type;
    }

    public LinkedServiceReference getStore() {
        return this.store;
    }

    public AzureKeyVaultSecretReference setStore(LinkedServiceReference store) {
        this.store = store;
        return this;
    }

    public Object getSecretName() {
        return this.secretName;
    }

    public AzureKeyVaultSecretReference setSecretName(Object secretName) {
        this.secretName = secretName;
        return this;
    }

    public Object getSecretVersion() {
        return this.secretVersion;
    }

    public AzureKeyVaultSecretReference setSecretVersion(Object secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("store", (JsonSerializable)this.store);
        jsonWriter.writeUntypedField("secretName", this.secretName);
        jsonWriter.writeStringField("type", this.type);
        if (this.secretVersion != null) {
            jsonWriter.writeUntypedField("secretVersion", this.secretVersion);
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureKeyVaultSecretReference fromJson(JsonReader jsonReader) throws IOException {
        return (AzureKeyVaultSecretReference)jsonReader.readObject(reader -> {
            AzureKeyVaultSecretReference deserializedAzureKeyVaultSecretReference = new AzureKeyVaultSecretReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("store".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.store = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("secretName".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.secretName = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.type = reader.getString();
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedAzureKeyVaultSecretReference.secretVersion = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureKeyVaultSecretReference;
        });
    }
}

