/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureDatabricksDeltaLakeExportCommand;
import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureDatabricksDeltaLakeSource
extends CopySource {
    private String type = "AzureDatabricksDeltaLakeSource";
    private Object query;
    private AzureDatabricksDeltaLakeExportCommand exportSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public AzureDatabricksDeltaLakeSource setQuery(Object query) {
        this.query = query;
        return this;
    }

    public AzureDatabricksDeltaLakeExportCommand getExportSettings() {
        return this.exportSettings;
    }

    public AzureDatabricksDeltaLakeSource setExportSettings(AzureDatabricksDeltaLakeExportCommand exportSettings) {
        this.exportSettings = exportSettings;
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        jsonWriter.writeJsonField("exportSettings", (JsonSerializable)this.exportSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDeltaLakeSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDeltaLakeSource)jsonReader.readObject(reader -> {
            AzureDatabricksDeltaLakeSource deserializedAzureDatabricksDeltaLakeSource = new AzureDatabricksDeltaLakeSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.query = reader.readUntyped();
                    continue;
                }
                if ("exportSettings".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSource.exportSettings = AzureDatabricksDeltaLakeExportCommand.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksDeltaLakeSource.setAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksDeltaLakeSource;
        });
    }
}

