/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.MetadataItem;
import com.azure.analytics.synapse.artifacts.models.StoreWriteSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureDataLakeStoreWriteSettings
extends StoreWriteSettings {
    private String type = "AzureDataLakeStoreWriteSettings";
    private Object expiryDateTime;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getExpiryDateTime() {
        return this.expiryDateTime;
    }

    public AzureDataLakeStoreWriteSettings setExpiryDateTime(Object expiryDateTime) {
        this.expiryDateTime = expiryDateTime;
        return this;
    }

    @Override
    public AzureDataLakeStoreWriteSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureDataLakeStoreWriteSettings setCopyBehavior(Object copyBehavior) {
        super.setCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public AzureDataLakeStoreWriteSettings setMetadata(List<MetadataItem> metadata) {
        super.setMetadata(metadata);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getCopyBehavior() != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.getCopyBehavior());
        }
        jsonWriter.writeArrayField("metadata", this.getMetadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.expiryDateTime != null) {
            jsonWriter.writeUntypedField("expiryDateTime", this.expiryDateTime);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataLakeStoreWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataLakeStoreWriteSettings)jsonReader.readObject(reader -> {
            AzureDataLakeStoreWriteSettings deserializedAzureDataLakeStoreWriteSettings = new AzureDataLakeStoreWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDataLakeStoreWriteSettings.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedAzureDataLakeStoreWriteSettings.setCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedAzureDataLakeStoreWriteSettings.setMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataLakeStoreWriteSettings.type = reader.getString();
                    continue;
                }
                if ("expiryDateTime".equals(fieldName)) {
                    deserializedAzureDataLakeStoreWriteSettings.expiryDateTime = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataLakeStoreWriteSettings.setAdditionalProperties(additionalProperties);
            return deserializedAzureDataLakeStoreWriteSettings;
        });
    }
}

