/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureBlobFSLinkedService
extends LinkedService {
    private String type = "AzureBlobFS";
    private Object url;
    private Object accountKey;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object azureCloudType;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object encryptedCredential;
    private Object sasUri;
    private SecretBase sasToken;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUrl() {
        return this.url;
    }

    public AzureBlobFSLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object getAccountKey() {
        return this.accountKey;
    }

    public AzureBlobFSLinkedService setAccountKey(Object accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureBlobFSLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureBlobFSLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureBlobFSLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public AzureBlobFSLinkedService setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureBlobFSLinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureBlobFSLinkedService setServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureBlobFSLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getSasUri() {
        return this.sasUri;
    }

    public AzureBlobFSLinkedService setSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    public SecretBase getSasToken() {
        return this.sasToken;
    }

    public AzureBlobFSLinkedService setSasToken(SecretBase sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureBlobFSLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureBlobFSLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureBlobFSLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureBlobFSLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureBlobFSLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureBlobFSLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.url != null || this.accountKey != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.tenant != null || this.azureCloudType != null || this.servicePrincipalCredentialType != null || this.servicePrincipalCredential != null || this.encryptedCredential != null || this.sasUri != null || this.sasToken != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.url != null) {
                jsonWriter.writeUntypedField("url", this.url);
            }
            if (this.accountKey != null) {
                jsonWriter.writeUntypedField("accountKey", this.accountKey);
            }
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.azureCloudType != null) {
                jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
            }
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.sasUri != null) {
                jsonWriter.writeUntypedField("sasUri", this.sasUri);
            }
            jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken);
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFSLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFSLinkedService)jsonReader.readObject(reader -> {
            AzureBlobFSLinkedService deserializedAzureBlobFSLinkedService = new AzureBlobFSLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureBlobFSLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureBlobFSLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobFSLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("url".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("accountKey".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.accountKey = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("azureCloudType".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.azureCloudType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredential".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.servicePrincipalCredential = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("sasUri".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.sasUri = reader.readUntyped();
                            continue;
                        }
                        if ("sasToken".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.sasToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureBlobFSLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobFSLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureBlobFSLinkedService;
        });
    }
}

