/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureBatchLinkedService
extends LinkedService {
    private String type = "AzureBatch";
    private Object accountName;
    private SecretBase accessKey;
    private Object batchUri;
    private Object poolName;
    private LinkedServiceReference linkedServiceName;
    private Object encryptedCredential;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getAccountName() {
        return this.accountName;
    }

    public AzureBatchLinkedService setAccountName(Object accountName) {
        this.accountName = accountName;
        return this;
    }

    public SecretBase getAccessKey() {
        return this.accessKey;
    }

    public AzureBatchLinkedService setAccessKey(SecretBase accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public Object getBatchUri() {
        return this.batchUri;
    }

    public AzureBatchLinkedService setBatchUri(Object batchUri) {
        this.batchUri = batchUri;
        return this;
    }

    public Object getPoolName() {
        return this.poolName;
    }

    public AzureBatchLinkedService setPoolName(Object poolName) {
        this.poolName = poolName;
        return this;
    }

    public LinkedServiceReference getLinkedServiceName() {
        return this.linkedServiceName;
    }

    public AzureBatchLinkedService setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureBatchLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureBatchLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureBatchLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureBatchLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureBatchLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureBatchLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureBatchLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.accountName != null || this.accessKey != null || this.batchUri != null || this.poolName != null || this.linkedServiceName != null || this.encryptedCredential != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("accountName", this.accountName);
            jsonWriter.writeJsonField("accessKey", (JsonSerializable)this.accessKey);
            jsonWriter.writeUntypedField("batchUri", this.batchUri);
            jsonWriter.writeUntypedField("poolName", this.poolName);
            jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBatchLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBatchLinkedService)jsonReader.readObject(reader -> {
            AzureBatchLinkedService deserializedAzureBatchLinkedService = new AzureBatchLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureBatchLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureBatchLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureBatchLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureBatchLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureBatchLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBatchLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("accountName".equals(fieldName)) {
                            deserializedAzureBatchLinkedService.accountName = reader.readUntyped();
                            continue;
                        }
                        if ("accessKey".equals(fieldName)) {
                            deserializedAzureBatchLinkedService.accessKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("batchUri".equals(fieldName)) {
                            deserializedAzureBatchLinkedService.batchUri = reader.readUntyped();
                            continue;
                        }
                        if ("poolName".equals(fieldName)) {
                            deserializedAzureBatchLinkedService.poolName = reader.readUntyped();
                            continue;
                        }
                        if ("linkedServiceName".equals(fieldName)) {
                            deserializedAzureBatchLinkedService.linkedServiceName = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureBatchLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureBatchLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBatchLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureBatchLinkedService;
        });
    }
}

