/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AmazonRedshiftLinkedService
extends LinkedService {
    private String type = "AmazonRedshift";
    private Object server;
    private Object username;
    private SecretBase password;
    private Object database;
    private Object port;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getServer() {
        return this.server;
    }

    public AmazonRedshiftLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public AmazonRedshiftLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public AmazonRedshiftLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public AmazonRedshiftLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public AmazonRedshiftLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonRedshiftLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public AmazonRedshiftLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AmazonRedshiftLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AmazonRedshiftLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AmazonRedshiftLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AmazonRedshiftLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.server != null || this.username != null || this.password != null || this.database != null || this.port != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("server", this.server);
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            jsonWriter.writeUntypedField("database", this.database);
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRedshiftLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRedshiftLinkedService)jsonReader.readObject(reader -> {
            AmazonRedshiftLinkedService deserializedAmazonRedshiftLinkedService = new AmazonRedshiftLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonRedshiftLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonRedshiftLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("server".equals(fieldName)) {
                            deserializedAmazonRedshiftLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedAmazonRedshiftLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedAmazonRedshiftLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedAmazonRedshiftLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedAmazonRedshiftLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAmazonRedshiftLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRedshiftLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAmazonRedshiftLinkedService;
        });
    }
}

