/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DependencyCondition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ActivityDependency
implements JsonSerializable<ActivityDependency> {
    private String activity;
    private List<DependencyCondition> dependencyConditions;
    private Map<String, Object> additionalProperties;

    public String getActivity() {
        return this.activity;
    }

    public ActivityDependency setActivity(String activity) {
        this.activity = activity;
        return this;
    }

    public List<DependencyCondition> getDependencyConditions() {
        return this.dependencyConditions;
    }

    public ActivityDependency setDependencyConditions(List<DependencyCondition> dependencyConditions) {
        this.dependencyConditions = dependencyConditions;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ActivityDependency setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("activity", this.activity);
        jsonWriter.writeArrayField("dependencyConditions", this.dependencyConditions, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ActivityDependency fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityDependency)jsonReader.readObject(reader -> {
            ActivityDependency deserializedActivityDependency = new ActivityDependency();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("activity".equals(fieldName)) {
                    deserializedActivityDependency.activity = reader.getString();
                    continue;
                }
                if ("dependencyConditions".equals(fieldName)) {
                    List dependencyConditions;
                    deserializedActivityDependency.dependencyConditions = dependencyConditions = reader.readArray(reader1 -> DependencyCondition.fromString(reader1.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedActivityDependency.additionalProperties = additionalProperties;
            return deserializedActivityDependency;
        });
    }
}

