/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.AppendVariableActivity;
import com.azure.analytics.synapse.artifacts.models.AzureDataExplorerCommandActivity;
import com.azure.analytics.synapse.artifacts.models.AzureFunctionActivity;
import com.azure.analytics.synapse.artifacts.models.AzureMLBatchExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.AzureMLExecutePipelineActivity;
import com.azure.analytics.synapse.artifacts.models.AzureMLUpdateResourceActivity;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.CopyActivity;
import com.azure.analytics.synapse.artifacts.models.CustomActivity;
import com.azure.analytics.synapse.artifacts.models.DataLakeAnalyticsUsqlActivity;
import com.azure.analytics.synapse.artifacts.models.DatabricksNotebookActivity;
import com.azure.analytics.synapse.artifacts.models.DatabricksSparkJarActivity;
import com.azure.analytics.synapse.artifacts.models.DatabricksSparkPythonActivity;
import com.azure.analytics.synapse.artifacts.models.DeleteActivity;
import com.azure.analytics.synapse.artifacts.models.ExecuteDataFlowActivity;
import com.azure.analytics.synapse.artifacts.models.ExecutePipelineActivity;
import com.azure.analytics.synapse.artifacts.models.ExecuteSsisPackageActivity;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.FailActivity;
import com.azure.analytics.synapse.artifacts.models.FilterActivity;
import com.azure.analytics.synapse.artifacts.models.ForEachActivity;
import com.azure.analytics.synapse.artifacts.models.GetMetadataActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightHiveActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightMapReduceActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightPigActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightSparkActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightStreamingActivity;
import com.azure.analytics.synapse.artifacts.models.IfConditionActivity;
import com.azure.analytics.synapse.artifacts.models.LookupActivity;
import com.azure.analytics.synapse.artifacts.models.ScriptActivity;
import com.azure.analytics.synapse.artifacts.models.SetVariableActivity;
import com.azure.analytics.synapse.artifacts.models.SqlPoolStoredProcedureActivity;
import com.azure.analytics.synapse.artifacts.models.SqlServerStoredProcedureActivity;
import com.azure.analytics.synapse.artifacts.models.SwitchActivity;
import com.azure.analytics.synapse.artifacts.models.SynapseNotebookActivity;
import com.azure.analytics.synapse.artifacts.models.SynapseSparkJobDefinitionActivity;
import com.azure.analytics.synapse.artifacts.models.UntilActivity;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.analytics.synapse.artifacts.models.ValidationActivity;
import com.azure.analytics.synapse.artifacts.models.WaitActivity;
import com.azure.analytics.synapse.artifacts.models.WebActivity;
import com.azure.analytics.synapse.artifacts.models.WebHookActivity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Activity
implements JsonSerializable<Activity> {
    private String type = "Activity";
    private String name;
    private String description;
    private ActivityState state;
    private ActivityOnInactiveMarkAs onInactiveMarkAs;
    private List<ActivityDependency> dependsOn;
    private List<UserProperty> userProperties;
    private Map<String, Object> additionalProperties;

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Activity setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Activity setDescription(String description) {
        this.description = description;
        return this;
    }

    public ActivityState getState() {
        return this.state;
    }

    public Activity setState(ActivityState state) {
        this.state = state;
        return this;
    }

    public ActivityOnInactiveMarkAs getOnInactiveMarkAs() {
        return this.onInactiveMarkAs;
    }

    public Activity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        this.onInactiveMarkAs = onInactiveMarkAs;
        return this;
    }

    public List<ActivityDependency> getDependsOn() {
        return this.dependsOn;
    }

    public Activity setDependsOn(List<ActivityDependency> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public Activity setUserProperties(List<UserProperty> userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Activity setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs == null ? null : this.onInactiveMarkAs.toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Activity fromJson(JsonReader jsonReader) throws IOException {
        return (Activity)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Activity activity;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Container".equals(discriminatorValue)) {
                    activity = ControlActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                    return activity;
                }
                if ("ExecutePipeline".equals(discriminatorValue)) {
                    activity = ExecutePipelineActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("IfCondition".equals(discriminatorValue)) {
                    activity = IfConditionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Switch".equals(discriminatorValue)) {
                    activity = SwitchActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("ForEach".equals(discriminatorValue)) {
                    activity = ForEachActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Wait".equals(discriminatorValue)) {
                    activity = WaitActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Fail".equals(discriminatorValue)) {
                    activity = FailActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Until".equals(discriminatorValue)) {
                    activity = UntilActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Validation".equals(discriminatorValue)) {
                    activity = ValidationActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Filter".equals(discriminatorValue)) {
                    activity = FilterActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SetVariable".equals(discriminatorValue)) {
                    activity = SetVariableActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AppendVariable".equals(discriminatorValue)) {
                    activity = AppendVariableActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("WebHook".equals(discriminatorValue)) {
                    activity = WebHookActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Execution".equals(discriminatorValue)) {
                    activity = ExecutionActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                    return activity;
                }
                if ("Copy".equals(discriminatorValue)) {
                    activity = CopyActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightHive".equals(discriminatorValue)) {
                    activity = HDInsightHiveActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightPig".equals(discriminatorValue)) {
                    activity = HDInsightPigActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightMapReduce".equals(discriminatorValue)) {
                    activity = HDInsightMapReduceActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightStreaming".equals(discriminatorValue)) {
                    activity = HDInsightStreamingActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("HDInsightSpark".equals(discriminatorValue)) {
                    activity = HDInsightSparkActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("ExecuteSSISPackage".equals(discriminatorValue)) {
                    activity = ExecuteSsisPackageActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Custom".equals(discriminatorValue)) {
                    activity = CustomActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SqlServerStoredProcedure".equals(discriminatorValue)) {
                    activity = SqlServerStoredProcedureActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Delete".equals(discriminatorValue)) {
                    activity = DeleteActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureDataExplorerCommand".equals(discriminatorValue)) {
                    activity = AzureDataExplorerCommandActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Lookup".equals(discriminatorValue)) {
                    activity = LookupActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("WebActivity".equals(discriminatorValue)) {
                    activity = WebActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("GetMetadata".equals(discriminatorValue)) {
                    activity = GetMetadataActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureMLBatchExecution".equals(discriminatorValue)) {
                    activity = AzureMLBatchExecutionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureMLUpdateResource".equals(discriminatorValue)) {
                    activity = AzureMLUpdateResourceActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureMLExecutePipeline".equals(discriminatorValue)) {
                    activity = AzureMLExecutePipelineActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DataLakeAnalyticsU-SQL".equals(discriminatorValue)) {
                    activity = DataLakeAnalyticsUsqlActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DatabricksNotebook".equals(discriminatorValue)) {
                    activity = DatabricksNotebookActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DatabricksSparkJar".equals(discriminatorValue)) {
                    activity = DatabricksSparkJarActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("DatabricksSparkPython".equals(discriminatorValue)) {
                    activity = DatabricksSparkPythonActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("AzureFunctionActivity".equals(discriminatorValue)) {
                    activity = AzureFunctionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("ExecuteDataFlow".equals(discriminatorValue)) {
                    activity = ExecuteDataFlowActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("Script".equals(discriminatorValue)) {
                    activity = ScriptActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SynapseNotebook".equals(discriminatorValue)) {
                    activity = SynapseNotebookActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SparkJob".equals(discriminatorValue)) {
                    activity = SynapseSparkJobDefinitionActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                if ("SqlPoolStoredProcedure".equals(discriminatorValue)) {
                    activity = SqlPoolStoredProcedureActivity.fromJson(readerToUse.reset());
                    return activity;
                }
                activity = Activity.fromJsonKnownDiscriminator(readerToUse.reset());
                return activity;
            }
        });
    }

    static Activity fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (Activity)jsonReader.readObject(reader -> {
            Activity deserializedActivity = new Activity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedActivity.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedActivity.type = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedActivity.description = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedActivity.state = ActivityState.fromString(reader.getString());
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedActivity.onInactiveMarkAs = ActivityOnInactiveMarkAs.fromString(reader.getString());
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn;
                    deserializedActivity.dependsOn = dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties;
                    deserializedActivity.userProperties = userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedActivity.additionalProperties = additionalProperties;
            return deserializedActivity;
        });
    }
}

