/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.analytics.synapse.artifacts.models.KqlScriptResource;
import com.azure.analytics.synapse.artifacts.models.KqlScriptsResourceCollectionResponse;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class KqlScriptsImpl {
    private final KqlScriptsService service;
    private final ArtifactsClientImpl client;

    KqlScriptsImpl(ArtifactsClientImpl client) {
        this.service = (KqlScriptsService)RestProxy.create(KqlScriptsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KqlScriptResource>> getAllSinglePageAsync() {
        String apiVersion = "2021-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAll(this.client.getEndpoint(), "2021-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getValue(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KqlScriptResource>> getAllSinglePageAsync(Context context) {
        String apiVersion = "2021-11-01-preview";
        String accept = "application/json";
        return this.service.getAll(this.client.getEndpoint(), "2021-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getValue(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KqlScriptResource> getAllAsync() {
        return new PagedFlux(() -> this.getAllSinglePageAsync(), nextLink -> this.getAllNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KqlScriptResource> getAllAsync(Context context) {
        return new PagedFlux(() -> this.getAllSinglePageAsync(context), nextLink -> this.getAllNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KqlScriptResource> getAllSinglePage() {
        return (PagedResponse)this.getAllSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KqlScriptResource> getAllSinglePage(Context context) {
        return (PagedResponse)this.getAllSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KqlScriptResource> getAll() {
        return new PagedIterable(this.getAllAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KqlScriptResource> getAll(Context context) {
        return new PagedIterable(this.getAllAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KqlScriptResource>> getAllNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAllNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getValue(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KqlScriptResource>> getAllNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getAllNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getValue(), ((KqlScriptsResourceCollectionResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KqlScriptResource> getAllNextSinglePage(String nextLink) {
        return (PagedResponse)this.getAllNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KqlScriptResource> getAllNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getAllNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientKqlScripts")
    public static interface KqlScriptsService {
        @Get(value="/kqlScripts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<KqlScriptsResourceCollectionResponse>> getAll(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<KqlScriptsResourceCollectionResponse>> getAllNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

