/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeListResponse;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeResource;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class IntegrationRuntimesImpl {
    private final IntegrationRuntimesService service;
    private final ArtifactsClientImpl client;

    IntegrationRuntimesImpl(ArtifactsClientImpl client) {
        this.service = (IntegrationRuntimesService)RestProxy.create(IntegrationRuntimesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IntegrationRuntimeListResponse>> listWithResponseAsync() {
        return FluxUtil.withContext(context -> this.listWithResponseAsync((Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IntegrationRuntimeListResponse>> listWithResponseAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.list(this.client.getEndpoint(), "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IntegrationRuntimeListResponse> listAsync() {
        return this.listWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeListResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IntegrationRuntimeListResponse> listAsync(Context context) {
        return this.listWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeListResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeListResponse> listWithResponse(Context context) {
        return (Response)this.listWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeListResponse list() {
        return (IntegrationRuntimeListResponse)this.listWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IntegrationRuntimeResource>> getWithResponseAsync(String integrationRuntimeName) {
        return FluxUtil.withContext(context -> this.getWithResponseAsync(integrationRuntimeName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IntegrationRuntimeResource>> getWithResponseAsync(String integrationRuntimeName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), "2020-12-01", integrationRuntimeName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IntegrationRuntimeResource> getAsync(String integrationRuntimeName) {
        return this.getWithResponseAsync(integrationRuntimeName).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IntegrationRuntimeResource> getAsync(String integrationRuntimeName, Context context) {
        return this.getWithResponseAsync(integrationRuntimeName, context).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeResource> getWithResponse(String integrationRuntimeName, Context context) {
        return (Response)this.getWithResponseAsync(integrationRuntimeName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeResource get(String integrationRuntimeName) {
        return (IntegrationRuntimeResource)this.getWithResponse(integrationRuntimeName, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientIntegrationRuntimes")
    public static interface IntegrationRuntimesService {
        @Get(value="/integrationRuntimes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<IntegrationRuntimeListResponse>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/integrationRuntimes/{integrationRuntimeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<IntegrationRuntimeResource>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="integrationRuntimeName") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

