/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.DatasetListResponse;
import com.azure.analytics.synapse.artifacts.models.DatasetResource;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class DatasetsImpl {
    private final DatasetsService service;
    private final ArtifactsClientImpl client;

    DatasetsImpl(ArtifactsClientImpl client) {
        this.service = (DatasetsService)RestProxy.create(DatasetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DatasetResource>> getDatasetsByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDatasetsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatasetListResponse)res.getValue()).getValue(), ((DatasetListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DatasetResource>> getDatasetsByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getDatasetsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatasetListResponse)res.getValue()).getValue(), ((DatasetListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatasetResource> getDatasetsByWorkspaceAsync() {
        return new PagedFlux(() -> this.getDatasetsByWorkspaceSinglePageAsync(), nextLink -> this.getDatasetsByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatasetResource> getDatasetsByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getDatasetsByWorkspaceSinglePageAsync(context), nextLink -> this.getDatasetsByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DatasetResource> getDatasetsByWorkspaceSinglePage() {
        return (PagedResponse)this.getDatasetsByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DatasetResource> getDatasetsByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.getDatasetsByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatasetResource> getDatasetsByWorkspace() {
        return new PagedIterable(this.getDatasetsByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatasetResource> getDatasetsByWorkspace(Context context) {
        return new PagedIterable(this.getDatasetsByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatasetResource>> createOrUpdateDatasetWithResponseAsync(String datasetName, DatasetResource dataset, String ifMatch) {
        return FluxUtil.withContext(context -> this.createOrUpdateDatasetWithResponseAsync(datasetName, dataset, ifMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatasetResource>> createOrUpdateDatasetWithResponseAsync(String datasetName, DatasetResource dataset, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdateDataset(this.client.getEndpoint(), datasetName, "2020-12-01", ifMatch, dataset, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> createOrUpdateDatasetAsync(String datasetName, DatasetResource dataset, String ifMatch) {
        return this.createOrUpdateDatasetWithResponseAsync(datasetName, dataset, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((DatasetResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> createOrUpdateDatasetAsync(String datasetName, DatasetResource dataset) {
        String ifMatch = null;
        return this.createOrUpdateDatasetWithResponseAsync(datasetName, dataset, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((DatasetResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> createOrUpdateDatasetAsync(String datasetName, DatasetResource dataset, String ifMatch, Context context) {
        return this.createOrUpdateDatasetWithResponseAsync(datasetName, dataset, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((DatasetResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatasetResource> createOrUpdateDatasetWithResponse(String datasetName, DatasetResource dataset, String ifMatch, Context context) {
        return (Response)this.createOrUpdateDatasetWithResponseAsync(datasetName, dataset, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource createOrUpdateDataset(String datasetName, DatasetResource dataset, String ifMatch) {
        return (DatasetResource)this.createOrUpdateDatasetWithResponse(datasetName, dataset, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource createOrUpdateDataset(String datasetName, DatasetResource dataset) {
        String ifMatch = null;
        return (DatasetResource)this.createOrUpdateDatasetWithResponse(datasetName, dataset, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatasetResource>> getDatasetWithResponseAsync(String datasetName, String ifNoneMatch) {
        return FluxUtil.withContext(context -> this.getDatasetWithResponseAsync(datasetName, ifNoneMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatasetResource>> getDatasetWithResponseAsync(String datasetName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getDataset(this.client.getEndpoint(), datasetName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> getDatasetAsync(String datasetName, String ifNoneMatch) {
        return this.getDatasetWithResponseAsync(datasetName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((DatasetResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> getDatasetAsync(String datasetName) {
        String ifNoneMatch = null;
        return this.getDatasetWithResponseAsync(datasetName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((DatasetResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> getDatasetAsync(String datasetName, String ifNoneMatch, Context context) {
        return this.getDatasetWithResponseAsync(datasetName, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((DatasetResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatasetResource> getDatasetWithResponse(String datasetName, String ifNoneMatch, Context context) {
        return (Response)this.getDatasetWithResponseAsync(datasetName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource getDataset(String datasetName, String ifNoneMatch) {
        return (DatasetResource)this.getDatasetWithResponse(datasetName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource getDataset(String datasetName) {
        String ifNoneMatch = null;
        return (DatasetResource)this.getDatasetWithResponse(datasetName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDatasetWithResponseAsync(String datasetName) {
        return FluxUtil.withContext(context -> this.deleteDatasetWithResponseAsync(datasetName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDatasetWithResponseAsync(String datasetName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteDataset(this.client.getEndpoint(), datasetName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDatasetAsync(String datasetName) {
        return this.deleteDatasetWithResponseAsync(datasetName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDatasetAsync(String datasetName, Context context) {
        return this.deleteDatasetWithResponseAsync(datasetName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDatasetWithResponse(String datasetName, Context context) {
        return (Response)this.deleteDatasetWithResponseAsync(datasetName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataset(String datasetName) {
        this.deleteDatasetWithResponse(datasetName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameDatasetWithResponseAsync(String datasetName, ArtifactRenameRequest request) {
        return FluxUtil.withContext(context -> this.renameDatasetWithResponseAsync(datasetName, request, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameDatasetWithResponseAsync(String datasetName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.renameDataset(this.client.getEndpoint(), datasetName, "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameDatasetAsync(String datasetName, ArtifactRenameRequest request) {
        return this.renameDatasetWithResponseAsync(datasetName, request).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameDatasetAsync(String datasetName, ArtifactRenameRequest request, Context context) {
        return this.renameDatasetWithResponseAsync(datasetName, request, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameDatasetWithResponse(String datasetName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renameDatasetWithResponseAsync(datasetName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameDataset(String datasetName, ArtifactRenameRequest request) {
        this.renameDatasetWithResponse(datasetName, request, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DatasetResource>> getDatasetsByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDatasetsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatasetListResponse)res.getValue()).getValue(), ((DatasetListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DatasetResource>> getDatasetsByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getDatasetsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatasetListResponse)res.getValue()).getValue(), ((DatasetListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DatasetResource> getDatasetsByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getDatasetsByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DatasetResource> getDatasetsByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getDatasetsByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientDatasets")
    public static interface DatasetsService {
        @Get(value="/datasets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DatasetListResponse>> getDatasetsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/datasets/{datasetName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DatasetResource>> createOrUpdateDataset(@HostParam(value="endpoint") String var1, @PathParam(value="datasetName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") DatasetResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/datasets/{datasetName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DatasetResource>> getDataset(@HostParam(value="endpoint") String var1, @PathParam(value="datasetName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/datasets/{datasetName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deleteDataset(@HostParam(value="endpoint") String var1, @PathParam(value="datasetName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/datasets/{datasetName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> renameDataset(@HostParam(value="endpoint") String var1, @PathParam(value="datasetName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DatasetListResponse>> getDatasetsByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

