/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.SparkJobDefinitionsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.SparkBatchJob;
import com.azure.analytics.synapse.artifacts.models.SparkJobDefinitionResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class SparkJobDefinitionClient {
    private final SparkJobDefinitionsImpl serviceClient;

    SparkJobDefinitionClient(SparkJobDefinitionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspace() {
        return this.serviceClient.getSparkJobDefinitionsByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspace(Context context) {
        return this.serviceClient.getSparkJobDefinitionsByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkJobDefinitionResource> createOrUpdateSparkJobDefinitionWithResponse(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateSparkJobDefinitionWithResponse(sparkJobDefinitionName, sparkJobDefinition, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource createOrUpdateSparkJobDefinition(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch) {
        return this.serviceClient.createOrUpdateSparkJobDefinition(sparkJobDefinitionName, sparkJobDefinition, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource createOrUpdateSparkJobDefinition(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition) {
        return this.serviceClient.createOrUpdateSparkJobDefinition(sparkJobDefinitionName, sparkJobDefinition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkJobDefinitionResource> getSparkJobDefinitionWithResponse(String sparkJobDefinitionName, String ifNoneMatch, Context context) {
        return this.serviceClient.getSparkJobDefinitionWithResponse(sparkJobDefinitionName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource getSparkJobDefinition(String sparkJobDefinitionName, String ifNoneMatch) {
        return this.serviceClient.getSparkJobDefinition(sparkJobDefinitionName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource getSparkJobDefinition(String sparkJobDefinitionName) {
        return this.serviceClient.getSparkJobDefinition(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSparkJobDefinitionWithResponse(String sparkJobDefinitionName, Context context) {
        return this.serviceClient.deleteSparkJobDefinitionWithResponse(sparkJobDefinitionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSparkJobDefinition(String sparkJobDefinitionName) {
        this.serviceClient.deleteSparkJobDefinition(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> executeSparkJobDefinitionWithResponse(String sparkJobDefinitionName, Context context) {
        return this.serviceClient.executeSparkJobDefinitionWithResponse(sparkJobDefinitionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob executeSparkJobDefinition(String sparkJobDefinitionName) {
        return this.serviceClient.executeSparkJobDefinition(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameSparkJobDefinitionWithResponse(String sparkJobDefinitionName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renameSparkJobDefinitionWithResponse(sparkJobDefinitionName, request, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameSparkJobDefinition(String sparkJobDefinitionName, ArtifactRenameRequest request) {
        this.serviceClient.renameSparkJobDefinition(sparkJobDefinitionName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> debugSparkJobDefinitionWithResponse(SparkJobDefinitionResource sparkJobDefinitionAzureResource, Context context) {
        return this.serviceClient.debugSparkJobDefinitionWithResponse(sparkJobDefinitionAzureResource, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob debugSparkJobDefinition(SparkJobDefinitionResource sparkJobDefinitionAzureResource) {
        return this.serviceClient.debugSparkJobDefinition(sparkJobDefinitionAzureResource);
    }
}

