/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.LinkedServicesImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class LinkedServiceClient {
    private final LinkedServicesImpl serviceClient;

    LinkedServiceClient(LinkedServicesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkedServiceResource> getLinkedServicesByWorkspace() {
        return this.serviceClient.getLinkedServicesByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkedServiceResource> getLinkedServicesByWorkspace(Context context) {
        return this.serviceClient.getLinkedServicesByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkedServiceResource> createOrUpdateLinkedServiceWithResponse(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateLinkedServiceWithResponse(linkedServiceName, linkedService, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource createOrUpdateLinkedService(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch) {
        return this.serviceClient.createOrUpdateLinkedService(linkedServiceName, linkedService, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource createOrUpdateLinkedService(String linkedServiceName, LinkedServiceResource linkedService) {
        return this.serviceClient.createOrUpdateLinkedService(linkedServiceName, linkedService);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkedServiceResource> getLinkedServiceWithResponse(String linkedServiceName, String ifNoneMatch, Context context) {
        return this.serviceClient.getLinkedServiceWithResponse(linkedServiceName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource getLinkedService(String linkedServiceName, String ifNoneMatch) {
        return this.serviceClient.getLinkedService(linkedServiceName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource getLinkedService(String linkedServiceName) {
        return this.serviceClient.getLinkedService(linkedServiceName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteLinkedServiceWithResponse(String linkedServiceName, Context context) {
        return this.serviceClient.deleteLinkedServiceWithResponse(linkedServiceName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteLinkedService(String linkedServiceName) {
        this.serviceClient.deleteLinkedService(linkedServiceName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameLinkedServiceWithResponse(String linkedServiceName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renameLinkedServiceWithResponse(linkedServiceName, request, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameLinkedService(String linkedServiceName, ArtifactRenameRequest request) {
        this.serviceClient.renameLinkedService(linkedServiceName, request);
    }
}

