/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.KqlScriptsOperationsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.KqlScriptResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class KqlScriptClient {
    private final KqlScriptsOperationsImpl serviceClient;

    KqlScriptClient(KqlScriptsOperationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KqlScriptResource> createOrUpdateWithResponse(String kqlScriptName, KqlScriptResource kqlScript, Context context) {
        return this.serviceClient.createOrUpdateWithResponse(kqlScriptName, kqlScript, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KqlScriptResource createOrUpdate(String kqlScriptName, KqlScriptResource kqlScript) {
        return this.serviceClient.createOrUpdate(kqlScriptName, kqlScript);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KqlScriptResource> getByNameWithResponse(String kqlScriptName, Context context) {
        return this.serviceClient.getByNameWithResponse(kqlScriptName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KqlScriptResource getByName(String kqlScriptName) {
        return this.serviceClient.getByName(kqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteByNameWithResponse(String kqlScriptName, Context context) {
        return this.serviceClient.deleteByNameWithResponse(kqlScriptName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteByName(String kqlScriptName) {
        this.serviceClient.deleteByName(kqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameWithResponse(String kqlScriptName, ArtifactRenameRequest renameRequest, Context context) {
        return this.serviceClient.renameWithResponse(kqlScriptName, renameRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rename(String kqlScriptName, ArtifactRenameRequest renameRequest) {
        this.serviceClient.rename(kqlScriptName, renameRequest);
    }
}

