/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.KqlScriptsOperationsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.KqlScriptResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class KqlScriptAsyncClient {
    private final KqlScriptsOperationsImpl serviceClient;

    KqlScriptAsyncClient(KqlScriptsOperationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KqlScriptResource>> createOrUpdateWithResponse(String kqlScriptName, KqlScriptResource kqlScript) {
        return this.serviceClient.createOrUpdateWithResponseAsync(kqlScriptName, kqlScript);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KqlScriptResource> createOrUpdate(String kqlScriptName, KqlScriptResource kqlScript) {
        return this.serviceClient.createOrUpdateAsync(kqlScriptName, kqlScript);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KqlScriptResource>> getByNameWithResponse(String kqlScriptName) {
        return this.serviceClient.getByNameWithResponseAsync(kqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KqlScriptResource> getByName(String kqlScriptName) {
        return this.serviceClient.getByNameAsync(kqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteByNameWithResponse(String kqlScriptName) {
        return this.serviceClient.deleteByNameWithResponseAsync(kqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteByName(String kqlScriptName) {
        return this.serviceClient.deleteByNameAsync(kqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameWithResponse(String kqlScriptName, ArtifactRenameRequest renameRequest) {
        return this.serviceClient.renameWithResponseAsync(kqlScriptName, renameRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rename(String kqlScriptName, ArtifactRenameRequest renameRequest) {
        return this.serviceClient.renameAsync(kqlScriptName, renameRequest);
    }
}

