/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.DataFlowsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.DataFlowResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class DataFlowAsyncClient {
    private final DataFlowsImpl serviceClient;

    DataFlowAsyncClient(DataFlowsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFlowResource>> createOrUpdateDataFlowWithResponse(String dataFlowName, DataFlowResource dataFlow, String ifMatch) {
        return this.serviceClient.createOrUpdateDataFlowWithResponseAsync(dataFlowName, dataFlow, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> createOrUpdateDataFlow(String dataFlowName, DataFlowResource dataFlow, String ifMatch) {
        return this.serviceClient.createOrUpdateDataFlowAsync(dataFlowName, dataFlow, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> createOrUpdateDataFlow(String dataFlowName, DataFlowResource dataFlow) {
        return this.serviceClient.createOrUpdateDataFlowAsync(dataFlowName, dataFlow);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFlowResource>> getDataFlowWithResponse(String dataFlowName, String ifNoneMatch) {
        return this.serviceClient.getDataFlowWithResponseAsync(dataFlowName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> getDataFlow(String dataFlowName, String ifNoneMatch) {
        return this.serviceClient.getDataFlowAsync(dataFlowName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> getDataFlow(String dataFlowName) {
        return this.serviceClient.getDataFlowAsync(dataFlowName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFlowWithResponse(String dataFlowName) {
        return this.serviceClient.deleteDataFlowWithResponseAsync(dataFlowName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFlow(String dataFlowName) {
        return this.serviceClient.deleteDataFlowAsync(dataFlowName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameDataFlowWithResponse(String dataFlowName, ArtifactRenameRequest request) {
        return this.serviceClient.renameDataFlowWithResponseAsync(dataFlowName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameDataFlow(String dataFlowName, ArtifactRenameRequest request) {
        return this.serviceClient.renameDataFlowAsync(dataFlowName, request);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFlowResource> getDataFlowsByWorkspace() {
        return this.serviceClient.getDataFlowsByWorkspaceAsync();
    }
}

