/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.BigDataPoolsAsyncClient;
import com.azure.analytics.synapse.artifacts.BigDataPoolsClient;
import com.azure.analytics.synapse.artifacts.DataFlowAsyncClient;
import com.azure.analytics.synapse.artifacts.DataFlowClient;
import com.azure.analytics.synapse.artifacts.DataFlowDebugSessionAsyncClient;
import com.azure.analytics.synapse.artifacts.DataFlowDebugSessionClient;
import com.azure.analytics.synapse.artifacts.DatasetAsyncClient;
import com.azure.analytics.synapse.artifacts.DatasetClient;
import com.azure.analytics.synapse.artifacts.IntegrationRuntimesAsyncClient;
import com.azure.analytics.synapse.artifacts.IntegrationRuntimesClient;
import com.azure.analytics.synapse.artifacts.KqlScriptAsyncClient;
import com.azure.analytics.synapse.artifacts.KqlScriptClient;
import com.azure.analytics.synapse.artifacts.KqlScriptsAsyncClient;
import com.azure.analytics.synapse.artifacts.KqlScriptsClient;
import com.azure.analytics.synapse.artifacts.LibraryAsyncClient;
import com.azure.analytics.synapse.artifacts.LibraryClient;
import com.azure.analytics.synapse.artifacts.LinkConnectionAsyncClient;
import com.azure.analytics.synapse.artifacts.LinkConnectionClient;
import com.azure.analytics.synapse.artifacts.LinkedServiceAsyncClient;
import com.azure.analytics.synapse.artifacts.LinkedServiceClient;
import com.azure.analytics.synapse.artifacts.MetastoreAsyncClient;
import com.azure.analytics.synapse.artifacts.MetastoreClient;
import com.azure.analytics.synapse.artifacts.NotebookAsyncClient;
import com.azure.analytics.synapse.artifacts.NotebookClient;
import com.azure.analytics.synapse.artifacts.NotebookOperationResultAsyncClient;
import com.azure.analytics.synapse.artifacts.NotebookOperationResultClient;
import com.azure.analytics.synapse.artifacts.PipelineAsyncClient;
import com.azure.analytics.synapse.artifacts.PipelineClient;
import com.azure.analytics.synapse.artifacts.PipelineRunAsyncClient;
import com.azure.analytics.synapse.artifacts.PipelineRunClient;
import com.azure.analytics.synapse.artifacts.RunNotebookAsyncClient;
import com.azure.analytics.synapse.artifacts.RunNotebookClient;
import com.azure.analytics.synapse.artifacts.SparkConfigurationAsyncClient;
import com.azure.analytics.synapse.artifacts.SparkConfigurationClient;
import com.azure.analytics.synapse.artifacts.SparkJobDefinitionAsyncClient;
import com.azure.analytics.synapse.artifacts.SparkJobDefinitionClient;
import com.azure.analytics.synapse.artifacts.SqlPoolsAsyncClient;
import com.azure.analytics.synapse.artifacts.SqlPoolsClient;
import com.azure.analytics.synapse.artifacts.SqlScriptAsyncClient;
import com.azure.analytics.synapse.artifacts.SqlScriptClient;
import com.azure.analytics.synapse.artifacts.TriggerAsyncClient;
import com.azure.analytics.synapse.artifacts.TriggerClient;
import com.azure.analytics.synapse.artifacts.TriggerRunAsyncClient;
import com.azure.analytics.synapse.artifacts.TriggerRunClient;
import com.azure.analytics.synapse.artifacts.WorkspaceAsyncClient;
import com.azure.analytics.synapse.artifacts.WorkspaceClient;
import com.azure.analytics.synapse.artifacts.WorkspaceGitRepoManagementAsyncClient;
import com.azure.analytics.synapse.artifacts.WorkspaceGitRepoManagementClient;
import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={LinkConnectionClient.class, RunNotebookClient.class, KqlScriptsClient.class, KqlScriptClient.class, MetastoreClient.class, SparkConfigurationClient.class, BigDataPoolsClient.class, DataFlowClient.class, DataFlowDebugSessionClient.class, DatasetClient.class, WorkspaceGitRepoManagementClient.class, IntegrationRuntimesClient.class, LibraryClient.class, LinkedServiceClient.class, NotebookClient.class, NotebookOperationResultClient.class, PipelineClient.class, PipelineRunClient.class, SparkJobDefinitionClient.class, SqlPoolsClient.class, SqlScriptClient.class, TriggerClient.class, TriggerRunClient.class, WorkspaceClient.class, LinkConnectionAsyncClient.class, RunNotebookAsyncClient.class, KqlScriptsAsyncClient.class, KqlScriptAsyncClient.class, MetastoreAsyncClient.class, SparkConfigurationAsyncClient.class, BigDataPoolsAsyncClient.class, DataFlowAsyncClient.class, DataFlowDebugSessionAsyncClient.class, DatasetAsyncClient.class, WorkspaceGitRepoManagementAsyncClient.class, IntegrationRuntimesAsyncClient.class, LibraryAsyncClient.class, LinkedServiceAsyncClient.class, NotebookAsyncClient.class, NotebookOperationResultAsyncClient.class, PipelineAsyncClient.class, PipelineRunAsyncClient.class, SparkJobDefinitionAsyncClient.class, SqlPoolsAsyncClient.class, SqlScriptAsyncClient.class, TriggerAsyncClient.class, TriggerRunAsyncClient.class, WorkspaceAsyncClient.class})
public final class ArtifactsClientBuilder
implements HttpTrait<ArtifactsClientBuilder>,
ConfigurationTrait<ArtifactsClientBuilder>,
TokenCredentialTrait<ArtifactsClientBuilder>,
EndpointTrait<ArtifactsClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String[] DEFAULT_SCOPES = new String[]{"https://dev.azuresynapse.net/.default"};
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-analytics-synapse-artifacts.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpClient httpClient;
    private HttpPipeline pipeline;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private String endpoint;
    private SerializerAdapter serializerAdapter;
    private RetryPolicy retryPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(ArtifactsClientBuilder.class);

    public ArtifactsClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ArtifactsClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.atInfo().log("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public ArtifactsClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public ArtifactsClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ArtifactsClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ArtifactsClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null.");
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public ArtifactsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ArtifactsClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public ArtifactsClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ArtifactsClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public ArtifactsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private ArtifactsClientImpl buildInnerClient() {
        this.validateClient();
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        SerializerAdapter localSerializerAdapter = this.serializerAdapter != null ? this.serializerAdapter : JacksonAdapter.createDefaultSerializerAdapter();
        ArtifactsClientImpl client = new ArtifactsClientImpl(localPipeline, localSerializerAdapter, this.endpoint);
        return client;
    }

    private void validateClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpLogOptions localHttpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)localHttpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)localClientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).forEach(p -> policies.add(p));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, DEFAULT_SCOPES));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).forEach(p -> policies.add(p));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(localHttpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).build();
        return httpPipeline;
    }

    public LinkConnectionAsyncClient buildLinkConnectionAsyncClient() {
        return new LinkConnectionAsyncClient(this.buildInnerClient().getLinkConnections());
    }

    public RunNotebookAsyncClient buildRunNotebookAsyncClient() {
        return new RunNotebookAsyncClient(this.buildInnerClient().getRunNotebooks());
    }

    public KqlScriptsAsyncClient buildKqlScriptsAsyncClient() {
        return new KqlScriptsAsyncClient(this.buildInnerClient().getKqlScripts());
    }

    public KqlScriptAsyncClient buildKqlScriptAsyncClient() {
        return new KqlScriptAsyncClient(this.buildInnerClient().getKqlScriptsOperations());
    }

    public MetastoreAsyncClient buildMetastoreAsyncClient() {
        return new MetastoreAsyncClient(this.buildInnerClient().getMetastores());
    }

    public SparkConfigurationAsyncClient buildSparkConfigurationAsyncClient() {
        return new SparkConfigurationAsyncClient(this.buildInnerClient().getSparkConfigurations());
    }

    public BigDataPoolsAsyncClient buildBigDataPoolsAsyncClient() {
        return new BigDataPoolsAsyncClient(this.buildInnerClient().getBigDataPools());
    }

    public DataFlowAsyncClient buildDataFlowAsyncClient() {
        return new DataFlowAsyncClient(this.buildInnerClient().getDataFlows());
    }

    public DataFlowDebugSessionAsyncClient buildDataFlowDebugSessionAsyncClient() {
        return new DataFlowDebugSessionAsyncClient(this.buildInnerClient().getDataFlowDebugSessions());
    }

    public DatasetAsyncClient buildDatasetAsyncClient() {
        return new DatasetAsyncClient(this.buildInnerClient().getDatasets());
    }

    public WorkspaceGitRepoManagementAsyncClient buildWorkspaceGitRepoManagementAsyncClient() {
        return new WorkspaceGitRepoManagementAsyncClient(this.buildInnerClient().getWorkspaceGitRepoManagements());
    }

    public IntegrationRuntimesAsyncClient buildIntegrationRuntimesAsyncClient() {
        return new IntegrationRuntimesAsyncClient(this.buildInnerClient().getIntegrationRuntimes());
    }

    public LibraryAsyncClient buildLibraryAsyncClient() {
        return new LibraryAsyncClient(this.buildInnerClient().getLibraries());
    }

    public LinkedServiceAsyncClient buildLinkedServiceAsyncClient() {
        return new LinkedServiceAsyncClient(this.buildInnerClient().getLinkedServices());
    }

    public NotebookAsyncClient buildNotebookAsyncClient() {
        return new NotebookAsyncClient(this.buildInnerClient().getNotebooks());
    }

    public NotebookOperationResultAsyncClient buildNotebookOperationResultAsyncClient() {
        return new NotebookOperationResultAsyncClient(this.buildInnerClient().getNotebookOperationResults());
    }

    public PipelineAsyncClient buildPipelineAsyncClient() {
        return new PipelineAsyncClient(this.buildInnerClient().getPipelines());
    }

    public PipelineRunAsyncClient buildPipelineRunAsyncClient() {
        return new PipelineRunAsyncClient(this.buildInnerClient().getPipelineRuns());
    }

    public SparkJobDefinitionAsyncClient buildSparkJobDefinitionAsyncClient() {
        return new SparkJobDefinitionAsyncClient(this.buildInnerClient().getSparkJobDefinitions());
    }

    public SqlPoolsAsyncClient buildSqlPoolsAsyncClient() {
        return new SqlPoolsAsyncClient(this.buildInnerClient().getSqlPools());
    }

    public SqlScriptAsyncClient buildSqlScriptAsyncClient() {
        return new SqlScriptAsyncClient(this.buildInnerClient().getSqlScripts());
    }

    public TriggerAsyncClient buildTriggerAsyncClient() {
        return new TriggerAsyncClient(this.buildInnerClient().getTriggers());
    }

    public TriggerRunAsyncClient buildTriggerRunAsyncClient() {
        return new TriggerRunAsyncClient(this.buildInnerClient().getTriggerRuns());
    }

    public WorkspaceAsyncClient buildWorkspaceAsyncClient() {
        return new WorkspaceAsyncClient(this.buildInnerClient().getWorkspaces());
    }

    public LinkConnectionClient buildLinkConnectionClient() {
        return new LinkConnectionClient(this.buildInnerClient().getLinkConnections());
    }

    public RunNotebookClient buildRunNotebookClient() {
        return new RunNotebookClient(this.buildInnerClient().getRunNotebooks());
    }

    public KqlScriptsClient buildKqlScriptsClient() {
        return new KqlScriptsClient(this.buildInnerClient().getKqlScripts());
    }

    public KqlScriptClient buildKqlScriptClient() {
        return new KqlScriptClient(this.buildInnerClient().getKqlScriptsOperations());
    }

    public MetastoreClient buildMetastoreClient() {
        return new MetastoreClient(this.buildInnerClient().getMetastores());
    }

    public SparkConfigurationClient buildSparkConfigurationClient() {
        return new SparkConfigurationClient(this.buildInnerClient().getSparkConfigurations());
    }

    public BigDataPoolsClient buildBigDataPoolsClient() {
        return new BigDataPoolsClient(this.buildInnerClient().getBigDataPools());
    }

    public DataFlowClient buildDataFlowClient() {
        return new DataFlowClient(this.buildInnerClient().getDataFlows());
    }

    public DataFlowDebugSessionClient buildDataFlowDebugSessionClient() {
        return new DataFlowDebugSessionClient(this.buildInnerClient().getDataFlowDebugSessions());
    }

    public DatasetClient buildDatasetClient() {
        return new DatasetClient(this.buildInnerClient().getDatasets());
    }

    public WorkspaceGitRepoManagementClient buildWorkspaceGitRepoManagementClient() {
        return new WorkspaceGitRepoManagementClient(this.buildInnerClient().getWorkspaceGitRepoManagements());
    }

    public IntegrationRuntimesClient buildIntegrationRuntimesClient() {
        return new IntegrationRuntimesClient(this.buildInnerClient().getIntegrationRuntimes());
    }

    public LibraryClient buildLibraryClient() {
        return new LibraryClient(this.buildInnerClient().getLibraries());
    }

    public LinkedServiceClient buildLinkedServiceClient() {
        return new LinkedServiceClient(this.buildInnerClient().getLinkedServices());
    }

    public NotebookClient buildNotebookClient() {
        return new NotebookClient(this.buildInnerClient().getNotebooks());
    }

    public NotebookOperationResultClient buildNotebookOperationResultClient() {
        return new NotebookOperationResultClient(this.buildInnerClient().getNotebookOperationResults());
    }

    public PipelineClient buildPipelineClient() {
        return new PipelineClient(this.buildInnerClient().getPipelines());
    }

    public PipelineRunClient buildPipelineRunClient() {
        return new PipelineRunClient(this.buildInnerClient().getPipelineRuns());
    }

    public SparkJobDefinitionClient buildSparkJobDefinitionClient() {
        return new SparkJobDefinitionClient(this.buildInnerClient().getSparkJobDefinitions());
    }

    public SqlPoolsClient buildSqlPoolsClient() {
        return new SqlPoolsClient(this.buildInnerClient().getSqlPools());
    }

    public SqlScriptClient buildSqlScriptClient() {
        return new SqlScriptClient(this.buildInnerClient().getSqlScripts());
    }

    public TriggerClient buildTriggerClient() {
        return new TriggerClient(this.buildInnerClient().getTriggers());
    }

    public TriggerRunClient buildTriggerRunClient() {
        return new TriggerRunClient(this.buildInnerClient().getTriggerRuns());
    }

    public WorkspaceClient buildWorkspaceClient() {
        return new WorkspaceClient(this.buildInnerClient().getWorkspaces());
    }
}

