/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.SearchFacetItem;
import com.azure.analytics.purview.datamap.models.SearchTaxonomySetting;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class QueryOptions
implements JsonSerializable<QueryOptions> {
    private String keywords;
    private Integer limit;
    private String continuationToken;
    private List<BinaryData> orderby;
    private BinaryData filter;
    private List<SearchFacetItem> facets;
    private SearchTaxonomySetting taxonomySetting;

    public String getKeywords() {
        return this.keywords;
    }

    public QueryOptions setKeywords(String keywords) {
        this.keywords = keywords;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public QueryOptions setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public QueryOptions setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    public List<BinaryData> getOrderby() {
        return this.orderby;
    }

    public QueryOptions setOrderby(List<BinaryData> orderby) {
        this.orderby = orderby;
        return this;
    }

    public BinaryData getFilter() {
        return this.filter;
    }

    public QueryOptions setFilter(BinaryData filter) {
        this.filter = filter;
        return this;
    }

    public List<SearchFacetItem> getFacets() {
        return this.facets;
    }

    public QueryOptions setFacets(List<SearchFacetItem> facets) {
        this.facets = facets;
        return this;
    }

    public SearchTaxonomySetting getTaxonomySetting() {
        return this.taxonomySetting;
    }

    public QueryOptions setTaxonomySetting(SearchTaxonomySetting taxonomySetting) {
        this.taxonomySetting = taxonomySetting;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keywords", this.keywords);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        jsonWriter.writeStringField("continuationToken", this.continuationToken);
        jsonWriter.writeArrayField("orderby", this.orderby, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        if (this.filter != null) {
            jsonWriter.writeFieldName("filter");
            this.filter.writeTo(jsonWriter);
        }
        jsonWriter.writeArrayField("facets", this.facets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("taxonomySetting", (JsonSerializable)this.taxonomySetting);
        return jsonWriter.writeEndObject();
    }

    public static QueryOptions fromJson(JsonReader jsonReader) throws IOException {
        return (QueryOptions)jsonReader.readObject(reader -> {
            QueryOptions deserializedQueryOptions = new QueryOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keywords".equals(fieldName)) {
                    deserializedQueryOptions.keywords = reader.getString();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedQueryOptions.limit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("continuationToken".equals(fieldName)) {
                    deserializedQueryOptions.continuationToken = reader.getString();
                    continue;
                }
                if ("orderby".equals(fieldName)) {
                    List orderby;
                    deserializedQueryOptions.orderby = orderby = reader.readArray(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedQueryOptions.filter = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("facets".equals(fieldName)) {
                    List facets;
                    deserializedQueryOptions.facets = facets = reader.readArray(reader1 -> SearchFacetItem.fromJson(reader1));
                    continue;
                }
                if ("taxonomySetting".equals(fieldName)) {
                    deserializedQueryOptions.taxonomySetting = SearchTaxonomySetting.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryOptions;
        });
    }
}

