/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class PurviewObjectId
implements JsonSerializable<PurviewObjectId> {
    private String guid;
    private String typeName;
    private Map<String, BinaryData> uniqueAttributes;
    private String name;
    private String displayText;
    private String itemPath;
    private String resourceId;
    private Map<String, BinaryData> properties;

    public String getGuid() {
        return this.guid;
    }

    public PurviewObjectId setGuid(String guid) {
        this.guid = guid;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public PurviewObjectId setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public Map<String, BinaryData> getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    public PurviewObjectId setUniqueAttributes(Map<String, BinaryData> uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PurviewObjectId setName(String name) {
        this.name = name;
        return this;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public PurviewObjectId setDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    public String getItemPath() {
        return this.itemPath;
    }

    public PurviewObjectId setItemPath(String itemPath) {
        this.itemPath = itemPath;
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public PurviewObjectId setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Map<String, BinaryData> getProperties() {
        return this.properties;
    }

    public PurviewObjectId setProperties(Map<String, BinaryData> properties) {
        this.properties = properties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("guid", this.guid);
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeMapField("uniqueAttributes", this.uniqueAttributes, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayText", this.displayText);
        jsonWriter.writeStringField("itemPath", this.itemPath);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        return jsonWriter.writeEndObject();
    }

    public static PurviewObjectId fromJson(JsonReader jsonReader) throws IOException {
        return (PurviewObjectId)jsonReader.readObject(reader -> {
            PurviewObjectId deserializedPurviewObjectId = new PurviewObjectId();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("guid".equals(fieldName)) {
                    deserializedPurviewObjectId.guid = reader.getString();
                    continue;
                }
                if ("typeName".equals(fieldName)) {
                    deserializedPurviewObjectId.typeName = reader.getString();
                    continue;
                }
                if ("uniqueAttributes".equals(fieldName)) {
                    Map uniqueAttributes;
                    deserializedPurviewObjectId.uniqueAttributes = uniqueAttributes = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPurviewObjectId.name = reader.getString();
                    continue;
                }
                if ("displayText".equals(fieldName)) {
                    deserializedPurviewObjectId.displayText = reader.getString();
                    continue;
                }
                if ("itemPath".equals(fieldName)) {
                    deserializedPurviewObjectId.itemPath = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedPurviewObjectId.resourceId = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedPurviewObjectId.properties = properties = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPurviewObjectId;
        });
    }
}

