/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.EntityStatus;
import com.azure.analytics.purview.datamap.models.TimeBoundary;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AtlasClassification
implements JsonSerializable<AtlasClassification> {
    private Map<String, BinaryData> attributes;
    private String typeName;
    private String lastModifiedTS;
    private String entityGuid;
    private EntityStatus entityStatus;
    private Boolean removePropagationsOnEntityDelete;
    private List<TimeBoundary> validityPeriods;

    public Map<String, BinaryData> getAttributes() {
        return this.attributes;
    }

    public AtlasClassification setAttributes(Map<String, BinaryData> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public AtlasClassification setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String getLastModifiedTS() {
        return this.lastModifiedTS;
    }

    public AtlasClassification setLastModifiedTS(String lastModifiedTS) {
        this.lastModifiedTS = lastModifiedTS;
        return this;
    }

    public String getEntityGuid() {
        return this.entityGuid;
    }

    public AtlasClassification setEntityGuid(String entityGuid) {
        this.entityGuid = entityGuid;
        return this;
    }

    public EntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public AtlasClassification setEntityStatus(EntityStatus entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    public Boolean isRemovePropagationsOnEntityDelete() {
        return this.removePropagationsOnEntityDelete;
    }

    public AtlasClassification setRemovePropagationsOnEntityDelete(Boolean removePropagationsOnEntityDelete) {
        this.removePropagationsOnEntityDelete = removePropagationsOnEntityDelete;
        return this;
    }

    public List<TimeBoundary> getValidityPeriods() {
        return this.validityPeriods;
    }

    public AtlasClassification setValidityPeriods(List<TimeBoundary> validityPeriods) {
        this.validityPeriods = validityPeriods;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("attributes", this.attributes, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("lastModifiedTS", this.lastModifiedTS);
        jsonWriter.writeStringField("entityGuid", this.entityGuid);
        jsonWriter.writeStringField("entityStatus", this.entityStatus == null ? null : this.entityStatus.toString());
        jsonWriter.writeBooleanField("removePropagationsOnEntityDelete", this.removePropagationsOnEntityDelete);
        jsonWriter.writeArrayField("validityPeriods", this.validityPeriods, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AtlasClassification fromJson(JsonReader jsonReader) throws IOException {
        return (AtlasClassification)jsonReader.readObject(reader -> {
            AtlasClassification deserializedAtlasClassification = new AtlasClassification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attributes".equals(fieldName)) {
                    Map attributes;
                    deserializedAtlasClassification.attributes = attributes = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("typeName".equals(fieldName)) {
                    deserializedAtlasClassification.typeName = reader.getString();
                    continue;
                }
                if ("lastModifiedTS".equals(fieldName)) {
                    deserializedAtlasClassification.lastModifiedTS = reader.getString();
                    continue;
                }
                if ("entityGuid".equals(fieldName)) {
                    deserializedAtlasClassification.entityGuid = reader.getString();
                    continue;
                }
                if ("entityStatus".equals(fieldName)) {
                    deserializedAtlasClassification.entityStatus = EntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("removePropagationsOnEntityDelete".equals(fieldName)) {
                    deserializedAtlasClassification.removePropagationsOnEntityDelete = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("validityPeriods".equals(fieldName)) {
                    List validityPeriods;
                    deserializedAtlasClassification.validityPeriods = validityPeriods = reader.readArray(reader1 -> TimeBoundary.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAtlasClassification;
        });
    }
}

