/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.implementation;

import com.azure.analytics.purview.datamap.PurviewDataMapServiceVersion;
import com.azure.analytics.purview.datamap.implementation.DiscoveriesImpl;
import com.azure.analytics.purview.datamap.implementation.EntitiesImpl;
import com.azure.analytics.purview.datamap.implementation.GlossariesImpl;
import com.azure.analytics.purview.datamap.implementation.LineagesImpl;
import com.azure.analytics.purview.datamap.implementation.RelationshipsImpl;
import com.azure.analytics.purview.datamap.implementation.TypeDefinitionsImpl;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

public final class DataMapClientImpl {
    private final String endpoint;
    private final PurviewDataMapServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final EntitiesImpl entities;
    private final GlossariesImpl glossaries;
    private final DiscoveriesImpl discoveries;
    private final LineagesImpl lineages;
    private final RelationshipsImpl relationships;
    private final TypeDefinitionsImpl typeDefinitions;

    public String getEndpoint() {
        return this.endpoint;
    }

    public PurviewDataMapServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public EntitiesImpl getEntities() {
        return this.entities;
    }

    public GlossariesImpl getGlossaries() {
        return this.glossaries;
    }

    public DiscoveriesImpl getDiscoveries() {
        return this.discoveries;
    }

    public LineagesImpl getLineages() {
        return this.lineages;
    }

    public RelationshipsImpl getRelationships() {
        return this.relationships;
    }

    public TypeDefinitionsImpl getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public DataMapClientImpl(String endpoint, PurviewDataMapServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DataMapClientImpl(HttpPipeline httpPipeline, String endpoint, PurviewDataMapServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DataMapClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, PurviewDataMapServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.entities = new EntitiesImpl(this);
        this.glossaries = new GlossariesImpl(this);
        this.discoveries = new DiscoveriesImpl(this);
        this.lineages = new LineagesImpl(this);
        this.relationships = new RelationshipsImpl(this);
        this.typeDefinitions = new TypeDefinitionsImpl(this);
    }
}

