/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.TypeDefinitionsImpl;
import com.azure.analytics.purview.datamap.models.AtlasBusinessMetadataDef;
import com.azure.analytics.purview.datamap.models.AtlasClassificationDef;
import com.azure.analytics.purview.datamap.models.AtlasEntityDef;
import com.azure.analytics.purview.datamap.models.AtlasEnumDef;
import com.azure.analytics.purview.datamap.models.AtlasRelationshipDef;
import com.azure.analytics.purview.datamap.models.AtlasStructDef;
import com.azure.analytics.purview.datamap.models.AtlasTypeDef;
import com.azure.analytics.purview.datamap.models.AtlasTypeDefHeader;
import com.azure.analytics.purview.datamap.models.AtlasTypesDef;
import com.azure.analytics.purview.datamap.models.TermTemplateDef;
import com.azure.analytics.purview.datamap.models.TypeCategory;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.TypeReference;
import java.util.List;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataMapClientBuilder.class, isAsync=true)
public final class TypeDefinitionAsyncClient {
    private final TypeDefinitionsImpl serviceClient;
    private static final TypeReference<List<AtlasTypeDefHeader>> TYPE_REFERENCE_LIST_ATLAS_TYPE_DEF_HEADER = new TypeReference<List<AtlasTypeDefHeader>>(){};

    TypeDefinitionAsyncClient(TypeDefinitionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getBusinessMetadataByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getBusinessMetadataByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getBusinessMetadataByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getBusinessMetadataByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassificationByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassificationByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEntityByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getEntityByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEntityByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getEntityByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEnumByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getEnumByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEnumByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getEnumByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRelationshipByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getRelationshipByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRelationshipByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getRelationshipByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getStructByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getStructByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getStructByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getStructByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchCreateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchCreateWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchUpdateWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> batchDeleteWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchDeleteWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getHeadersWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getHeadersWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTermTemplateByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getTermTemplateByIdWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTermTemplateByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getTermTemplateByNameWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasBusinessMetadataDef> getBusinessMetadataById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getBusinessMetadataByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasBusinessMetadataDef)protocolMethodData.toObject(AtlasBusinessMetadataDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasBusinessMetadataDef> getBusinessMetadataByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getBusinessMetadataByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasBusinessMetadataDef)protocolMethodData.toObject(AtlasBusinessMetadataDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasClassificationDef> getClassificationById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getClassificationByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasClassificationDef)protocolMethodData.toObject(AtlasClassificationDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasClassificationDef> getClassificationByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getClassificationByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasClassificationDef)protocolMethodData.toObject(AtlasClassificationDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntityDef> getEntityById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEntityByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntityDef)protocolMethodData.toObject(AtlasEntityDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntityDef> getEntityByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEntityByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntityDef)protocolMethodData.toObject(AtlasEntityDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEnumDef> getEnumById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEnumByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEnumDef)protocolMethodData.toObject(AtlasEnumDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEnumDef> getEnumByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEnumByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEnumDef)protocolMethodData.toObject(AtlasEnumDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasRelationshipDef> getRelationshipById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRelationshipByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasRelationshipDef)protocolMethodData.toObject(AtlasRelationshipDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasRelationshipDef> getRelationshipByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRelationshipByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasRelationshipDef)protocolMethodData.toObject(AtlasRelationshipDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasStructDef> getStructById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getStructByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasStructDef)protocolMethodData.toObject(AtlasStructDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasStructDef> getStructByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getStructByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasStructDef)protocolMethodData.toObject(AtlasStructDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasTypeDef> getById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasTypeDef)protocolMethodData.toObject(AtlasTypeDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasTypeDef> getByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasTypeDef)protocolMethodData.toObject(AtlasTypeDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteWithResponse(name, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasTypesDef> get(Boolean includeTermTemplate, TypeCategory type) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermTemplate != null) {
            requestOptions.addQueryParam("includeTermTemplate", String.valueOf(includeTermTemplate), false);
        }
        if (type != null) {
            requestOptions.addQueryParam("type", type.toString(), false);
        }
        return this.getWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasTypesDef)protocolMethodData.toObject(AtlasTypesDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasTypesDef> get() {
        RequestOptions requestOptions = new RequestOptions();
        return this.getWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasTypesDef)protocolMethodData.toObject(AtlasTypesDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasTypesDef> batchCreate(AtlasTypesDef body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchCreateWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasTypesDef)protocolMethodData.toObject(AtlasTypesDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasTypesDef> batchUpdate(AtlasTypesDef body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasTypesDef)protocolMethodData.toObject(AtlasTypesDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> batchDelete(AtlasTypesDef body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchDeleteWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasTypeDefHeader>> getHeaders(Boolean includeTermTemplate, TypeCategory type) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermTemplate != null) {
            requestOptions.addQueryParam("includeTermTemplate", String.valueOf(includeTermTemplate), false);
        }
        if (type != null) {
            requestOptions.addQueryParam("type", type.toString(), false);
        }
        return this.getHeadersWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_TYPE_DEF_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasTypeDefHeader>> getHeaders() {
        RequestOptions requestOptions = new RequestOptions();
        return this.getHeadersWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_TYPE_DEF_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TermTemplateDef> getTermTemplateById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTermTemplateByIdWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TermTemplateDef)protocolMethodData.toObject(TermTemplateDef.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TermTemplateDef> getTermTemplateByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTermTemplateByNameWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TermTemplateDef)protocolMethodData.toObject(TermTemplateDef.class));
    }
}

