/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.LineagesImpl;
import com.azure.analytics.purview.datamap.models.AtlasLineageInfo;
import com.azure.analytics.purview.datamap.models.LineageDirection;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=DataMapClientBuilder.class)
public final class LineageClient {
    private final LineagesImpl serviceClient;

    LineageClient(LineagesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getWithResponse(String guid, String direction, RequestOptions requestOptions) {
        return this.serviceClient.getWithResponse(guid, direction, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getNextPageWithResponse(String guid, String direction, RequestOptions requestOptions) {
        return this.serviceClient.getNextPageWithResponse(guid, direction, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getByUniqueAttributeWithResponse(String typeName, String direction, RequestOptions requestOptions) {
        return this.serviceClient.getByUniqueAttributeWithResponse(typeName, direction, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasLineageInfo get(String guid, LineageDirection direction, Integer depth) {
        RequestOptions requestOptions = new RequestOptions();
        if (depth != null) {
            requestOptions.addQueryParam("depth", String.valueOf(depth), false);
        }
        return (AtlasLineageInfo)((BinaryData)this.getWithResponse(guid, direction.toString(), requestOptions).getValue()).toObject(AtlasLineageInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasLineageInfo get(String guid, LineageDirection direction) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasLineageInfo)((BinaryData)this.getWithResponse(guid, direction.toString(), requestOptions).getValue()).toObject(AtlasLineageInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasLineageInfo getNextPage(String guid, LineageDirection direction, Integer offset, Integer limit) {
        RequestOptions requestOptions = new RequestOptions();
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        return (AtlasLineageInfo)((BinaryData)this.getNextPageWithResponse(guid, direction.toString(), requestOptions).getValue()).toObject(AtlasLineageInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasLineageInfo getNextPage(String guid, LineageDirection direction) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasLineageInfo)((BinaryData)this.getNextPageWithResponse(guid, direction.toString(), requestOptions).getValue()).toObject(AtlasLineageInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasLineageInfo getByUniqueAttribute(String typeName, LineageDirection direction, Integer depth, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (depth != null) {
            requestOptions.addQueryParam("depth", String.valueOf(depth), false);
        }
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return (AtlasLineageInfo)((BinaryData)this.getByUniqueAttributeWithResponse(typeName, direction.toString(), requestOptions).getValue()).toObject(AtlasLineageInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasLineageInfo getByUniqueAttribute(String typeName, LineageDirection direction) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasLineageInfo)((BinaryData)this.getByUniqueAttributeWithResponse(typeName, direction.toString(), requestOptions).getValue()).toObject(AtlasLineageInfo.class);
    }
}

