/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.PreBuiltTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SentimentAnalysisTaskParameters
extends PreBuiltTaskParameters {
    private Boolean opinionMining;
    private StringIndexType stringIndexType;

    public Boolean isOpinionMining() {
        return this.opinionMining;
    }

    public SentimentAnalysisTaskParameters setOpinionMining(Boolean opinionMining) {
        this.opinionMining = opinionMining;
        return this;
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public SentimentAnalysisTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    @Override
    public SentimentAnalysisTaskParameters setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public SentimentAnalysisTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", this.isLoggingOptOut());
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeBooleanField("opinionMining", this.opinionMining);
        jsonWriter.writeStringField("stringIndexType", this.stringIndexType == null ? null : this.stringIndexType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SentimentAnalysisTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentAnalysisTaskParameters)jsonReader.readObject(reader -> {
            SentimentAnalysisTaskParameters deserializedSentimentAnalysisTaskParameters = new SentimentAnalysisTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggingOptOut".equals(fieldName)) {
                    deserializedSentimentAnalysisTaskParameters.setLoggingOptOut((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedSentimentAnalysisTaskParameters.setModelVersion(reader.getString());
                    continue;
                }
                if ("opinionMining".equals(fieldName)) {
                    deserializedSentimentAnalysisTaskParameters.opinionMining = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stringIndexType".equals(fieldName)) {
                    deserializedSentimentAnalysisTaskParameters.stringIndexType = StringIndexType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentimentAnalysisTaskParameters;
        });
    }
}

