/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class KeyPhrasesDocumentResult
extends DocumentResult {
    private List<String> keyPhrases;

    public List<String> getKeyPhrases() {
        return this.keyPhrases;
    }

    public KeyPhrasesDocumentResult setKeyPhrases(List<String> keyPhrases) {
        this.keyPhrases = keyPhrases;
        return this;
    }

    @Override
    public KeyPhrasesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public KeyPhrasesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public KeyPhrasesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("keyPhrases", this.keyPhrases, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static KeyPhrasesDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (KeyPhrasesDocumentResult)jsonReader.readObject(reader -> {
            KeyPhrasesDocumentResult deserializedKeyPhrasesDocumentResult = new KeyPhrasesDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKeyPhrasesDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedKeyPhrasesDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedKeyPhrasesDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("keyPhrases".equals(fieldName)) {
                    List keyPhrases;
                    deserializedKeyPhrasesDocumentResult.keyPhrases = keyPhrases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyPhrasesDocumentResult;
        });
    }
}

