/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.HealthcareEntitiesDocumentResult;
import com.azure.ai.textanalytics.implementation.models.HealthcareEntity;
import com.azure.ai.textanalytics.implementation.models.HealthcareRelation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class HealthcareResultDocumentsItem
extends HealthcareEntitiesDocumentResult {
    @Override
    public HealthcareResultDocumentsItem setEntities(List<HealthcareEntity> entities) {
        super.setEntities(entities);
        return this;
    }

    @Override
    public HealthcareResultDocumentsItem setRelations(List<HealthcareRelation> relations) {
        super.setRelations(relations);
        return this;
    }

    @Override
    public HealthcareResultDocumentsItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public HealthcareResultDocumentsItem setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings((List)warnings);
        return this;
    }

    @Override
    public HealthcareResultDocumentsItem setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("entities", this.getEntities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("relations", this.getRelations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        return jsonWriter.writeEndObject();
    }

    public static HealthcareResultDocumentsItem fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareResultDocumentsItem)jsonReader.readObject(reader -> {
            HealthcareResultDocumentsItem deserializedHealthcareResultDocumentsItem = new HealthcareResultDocumentsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedHealthcareResultDocumentsItem.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedHealthcareResultDocumentsItem.setWarnings(warnings);
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities = reader.readArray(reader1 -> HealthcareEntity.fromJson(reader1));
                    deserializedHealthcareResultDocumentsItem.setEntities(entities);
                    continue;
                }
                if ("relations".equals(fieldName)) {
                    List relations = reader.readArray(reader1 -> HealthcareRelation.fromJson(reader1));
                    deserializedHealthcareResultDocumentsItem.setRelations(relations);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedHealthcareResultDocumentsItem.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareResultDocumentsItem;
        });
    }
}

