/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AbstractiveSummarizationResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AbstractiveSummarizationLROResult
extends AnalyzeTextLROResult {
    private AnalyzeTextLROResultsKind kind = AnalyzeTextLROResultsKind.ABSTRACTIVE_SUMMARIZATION_LRORESULTS;
    private AbstractiveSummarizationResult results;

    @Override
    public AnalyzeTextLROResultsKind getKind() {
        return this.kind;
    }

    public AbstractiveSummarizationResult getResults() {
        return this.results;
    }

    public AbstractiveSummarizationLROResult setResults(AbstractiveSummarizationResult results) {
        this.results = results;
        return this;
    }

    @Override
    public AbstractiveSummarizationLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public AbstractiveSummarizationLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public AbstractiveSummarizationLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdateDateTime", this.getLastUpdateDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdateDateTime()));
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static AbstractiveSummarizationLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (AbstractiveSummarizationLROResult)jsonReader.readObject(reader -> {
            AbstractiveSummarizationLROResult deserializedAbstractiveSummarizationLROResult = new AbstractiveSummarizationLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedAbstractiveSummarizationLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAbstractiveSummarizationLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedAbstractiveSummarizationLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedAbstractiveSummarizationLROResult.results = AbstractiveSummarizationResult.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAbstractiveSummarizationLROResult.kind = AnalyzeTextLROResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAbstractiveSummarizationLROResult;
        });
    }
}

