/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.ExtractedSummarySentence;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ExtractedSummaryDocumentResult
extends DocumentResult {
    private List<ExtractedSummarySentence> sentences;

    public List<ExtractedSummarySentence> getSentences() {
        return this.sentences;
    }

    public ExtractedSummaryDocumentResult setSentences(List<ExtractedSummarySentence> sentences) {
        this.sentences = sentences;
        return this;
    }

    @Override
    public ExtractedSummaryDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public ExtractedSummaryDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public ExtractedSummaryDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("sentences", this.sentences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExtractedSummaryDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (ExtractedSummaryDocumentResult)jsonReader.readObject(reader -> {
            ExtractedSummaryDocumentResult deserializedExtractedSummaryDocumentResult = new ExtractedSummaryDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExtractedSummaryDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedExtractedSummaryDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedExtractedSummaryDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("sentences".equals(fieldName)) {
                    List sentences;
                    deserializedExtractedSummaryDocumentResult.sentences = sentences = reader.readArray(reader1 -> ExtractedSummarySentence.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtractedSummaryDocumentResult;
        });
    }
}

