/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class EntityLinkingLROResult
extends AnalyzeTextLROResult {
    private AnalyzeTextLROResultsKind kind = AnalyzeTextLROResultsKind.ENTITY_LINKING_LRORESULTS;
    private EntityLinkingResult results;

    @Override
    public AnalyzeTextLROResultsKind getKind() {
        return this.kind;
    }

    public EntityLinkingResult getResults() {
        return this.results;
    }

    public EntityLinkingLROResult setResults(EntityLinkingResult results) {
        this.results = results;
        return this;
    }

    @Override
    public EntityLinkingLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public EntityLinkingLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public EntityLinkingLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdateDateTime", this.getLastUpdateDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdateDateTime()));
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static EntityLinkingLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntityLinkingLROResult)jsonReader.readObject(reader -> {
            EntityLinkingLROResult deserializedEntityLinkingLROResult = new EntityLinkingLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.results = EntityLinkingResult.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.kind = AnalyzeTextLROResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityLinkingLROResult;
        });
    }
}

